/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.torocraft.toroquest.ToroQuest;
import net.torocraft.toroquest.civilization.CivilizationType;
import net.torocraft.toroquest.civilization.CivilizationUtil;
import net.torocraft.toroquest.civilization.CivilizationsWorldSaveData;
import net.torocraft.toroquest.civilization.Province;
import net.torocraft.toroquest.civilization.player.PlayerCivilizationCapabilityImpl;
import net.torocraft.toroquest.civilization.quests.util.QuestData;
import net.torocraft.toroquest.civilization.quests.util.QuestDelegator;
import net.torocraft.toroquest.generation.BastionsLairGenerator;
import net.torocraft.toroquest.generation.GraveyardGenerator;
import net.torocraft.toroquest.generation.MageTowerGenerator;
import net.torocraft.toroquest.generation.MonolithGenerator;
import net.torocraft.toroquest.generation.ThroneRoomGenerator;
import net.torocraft.toroquest.gui.VillageLordGuiHandler;
import net.torocraft.toroquest.util.BookCreator;

public class ToroQuestCommand
extends CommandBase {
    public String func_71517_b() {
        return "tq";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.torogen.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        if (args.length < 1) {
            throw new WrongUsageException("commands.tq.usage", new Object[0]);
        }
        String command = args[0];
        System.out.println("command " + command);
        if ("rep".equals(command)) {
            this.adjustRep(server, player, args);
        } else if ("list".equals(command)) {
            this.listCommand(player, args);
        } else if ("gen".equals(command)) {
            this.genCommand(player, args);
        } else if ("gui".equals(command)) {
            this.guiCommand(player, args);
        } else if ("quest".equals(command)) {
            this.questCommand(player, args);
        } else if ("book".equals(command)) {
            this.bookCommand(player, args);
        } else {
            throw new WrongUsageException("commands.tq.usage", new Object[0]);
        }
    }

    private void bookCommand(EntityPlayer player, String[] args) throws CommandException {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(BookCreator.createBook(BookCreator.BookTypes.CIV_LORE, "pantheon_unbiased_book_1"));
        this.dropItems(player, items);
    }

    private void listCommand(EntityPlayer player, String[] args) throws CommandException {
        List<Province> provinces = CivilizationsWorldSaveData.get(player.field_70170_p).getProvinces();
        StringBuilder sb = new StringBuilder();
        for (Province province : provinces) {
            sb.append(province.toString()).append("\n");
        }
        player.func_145747_a((ITextComponent)new TextComponentString(sb.toString()));
    }

    private void adjustRep(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        CivilizationType civ;
        int amount;
        if (args.length < 2) {
            throw new WrongUsageException("commands.tq.usage", new Object[0]);
        }
        try {
            amount = Integer.parseInt(args[1], 10);
        }
        catch (Exception e) {
            throw new WrongUsageException("commands.tq.usage", new Object[]{new Object[0], e});
        }
        Entity entity = null;
        EntityPlayer playerToSet = player;
        if (args.length >= 3) {
            entity = ToroQuestCommand.func_184885_b((MinecraftServer)server, (ICommandSender)player, (String)args[2]);
        }
        if (entity != null && entity instanceof EntityPlayer) {
            playerToSet = (EntityPlayer)entity;
        }
        if (args.length >= 4) {
            civ = CivilizationType.valueOf(args[3]);
        } else {
            Province province = CivilizationUtil.getProvinceAt(player.func_130014_f_(), player.field_70176_ah, player.field_70164_aj);
            if (province == null || province.civilization == null) {
                throw new WrongUsageException("commands.tq.not_in_civ", new Object[0]);
            }
            civ = province.civilization;
        }
        PlayerCivilizationCapabilityImpl.get(playerToSet).setReputation(civ, amount);
    }

    private void genCommand(EntityPlayer player, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException("commands.tq.usage", new Object[0]);
        }
        String structure = args[1];
        if ("throne_room".equals(structure)) {
            new ThroneRoomGenerator().func_180709_b(player.func_130014_f_(), player.func_130014_f_().field_73012_v, player.func_180425_c());
            return;
        }
        if ("mage_tower".equals(structure)) {
            new MageTowerGenerator().func_180709_b(player.func_130014_f_(), player.func_130014_f_().field_73012_v, player.func_180425_c());
            return;
        }
        if ("bastions_lair".equals(structure)) {
            new BastionsLairGenerator().func_180709_b(player.func_130014_f_(), player.func_130014_f_().field_73012_v, player.func_180425_c());
            return;
        }
        if ("monolith".equals(structure)) {
            new MonolithGenerator().func_180709_b(player.func_130014_f_(), player.func_130014_f_().field_73012_v, player.func_180425_c());
            return;
        }
        if ("graveyard".equals(structure)) {
            new GraveyardGenerator().func_180709_b(player.func_130014_f_(), player.func_130014_f_().field_73012_v, player.func_180425_c());
            return;
        }
        throw new WrongUsageException("commands.tq.usage", new Object[0]);
    }

    private void guiCommand(EntityPlayer player, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException("commans.tq.usage", new Object[0]);
        }
        String type = args[1];
        if ("lord".equals(type)) {
            player.openGui((Object)ToroQuest.INSTANCE, VillageLordGuiHandler.getGuiID(), player.field_70170_p, player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
            return;
        }
        throw new WrongUsageException("commands.tq.usage", new Object[0]);
    }

    private void questCommand(EntityPlayer player, String[] args) throws CommandException {
        if (args.length < 2) {
            throw new WrongUsageException("commans.tq.usage", new Object[0]);
        }
        String sub = args[1];
        if ("test".equals(sub)) {
            List<ItemStack> items = this.pullHotbarItems(player);
            this.dropItems(player, items);
            return;
        }
        if ("list".equals(sub)) {
            Set<QuestData> quests = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuests();
            QuestDelegator quest = new QuestDelegator(new QuestData());
            for (QuestData data : quests) {
                quest.setData(data);
                player.func_145747_a((ITextComponent)new TextComponentString("----"));
                player.func_145747_a((ITextComponent)new TextComponentString(quest.getTitle()));
                player.func_145747_a((ITextComponent)new TextComponentString(quest.getDescription()));
            }
            if (quests.size() < 1) {
                player.func_145747_a((ITextComponent)new TextComponentString("No accepted quests"));
            }
            return;
        }
        Province province = CivilizationUtil.getProvinceAt(player.func_130014_f_(), player.field_70176_ah, player.field_70164_aj);
        if (province == null || province.civilization == null) {
            throw new WrongUsageException("commands.tq.not_in_civ", new Object[0]);
        }
        if ("next".equals(sub)) {
            QuestDelegator quest = new QuestDelegator(PlayerCivilizationCapabilityImpl.get(player).getNextQuestFor(province));
            if (quest.getData() == null) {
                throw new NullPointerException("next quest should never be null");
            }
            player.func_145747_a((ITextComponent)new TextComponentString(quest.getTitle()));
        } else if ("current".equals(sub)) {
            QuestData data = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuestFor(province);
            if (data == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("No quest has been accepted"));
            } else {
                QuestDelegator quest = new QuestDelegator(data);
                player.func_145747_a((ITextComponent)new TextComponentString(quest.getTitle()));
                player.func_145747_a((ITextComponent)new TextComponentString(quest.getDescription()));
            }
        } else if ("accept".equals(sub)) {
            List<ItemStack> startItems = this.pullHotbarItems(player);
            List<ItemStack> returnItems = PlayerCivilizationCapabilityImpl.get(player).acceptQuest(startItems);
            if (returnItems == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Quest not Accepted"));
                this.dropItems(player, startItems);
            } else {
                QuestDelegator quest = new QuestDelegator(PlayerCivilizationCapabilityImpl.get(player).getCurrentQuestFor(province));
                player.func_145747_a((ITextComponent)new TextComponentString("Accepted: " + quest.getTitle()));
                player.func_145747_a((ITextComponent)new TextComponentString(quest.getDescription()));
                this.dropItems(player, returnItems);
            }
        } else if ("complete".equals(sub)) {
            QuestData data = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuestFor(province);
            if (data == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("No accepted quest to complete"));
                return;
            }
            QuestDelegator curQuest = new QuestDelegator(data);
            List<ItemStack> beforeItems = this.pullHotbarItems(player);
            List<ItemStack> afterItems = PlayerCivilizationCapabilityImpl.get(player).completeQuest(beforeItems);
            if (afterItems == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Quest not Completed"));
                this.dropItems(player, beforeItems);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("Completed: " + curQuest.getTitle()));
                this.dropItems(player, afterItems);
            }
        } else if ("reject".equals(sub)) {
            QuestData data = PlayerCivilizationCapabilityImpl.get(player).getCurrentQuestFor(province);
            if (data == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("No accepted quest to complete"));
                return;
            }
            QuestDelegator curQuest = new QuestDelegator(data);
            List<ItemStack> beforeItems = this.pullHotbarItems(player);
            List<ItemStack> afterItems = PlayerCivilizationCapabilityImpl.get(player).rejectQuest(beforeItems);
            if (afterItems == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Unable to reject quest"));
                this.dropItems(player, beforeItems);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("Rejected: " + curQuest.getTitle()));
                this.dropItems(player, afterItems);
            }
        } else {
            throw new WrongUsageException("commands.tq.usage", new Object[0]);
        }
    }

    private List<ItemStack> pullHotbarItems(EntityPlayer player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        InventoryPlayer inv = player.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || !InventoryPlayer.func_184435_e((int)i)) continue;
            ItemStack stack = inv.func_70301_a(i);
            inv.func_70299_a(i, ItemStack.field_190927_a);
            items.add(stack);
        }
        return items;
    }

    private void dropItems(EntityPlayer player, List<ItemStack> items) {
        for (ItemStack stack : items) {
            EntityItem dropItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
            dropItem.func_174868_q();
            player.field_70170_p.func_72838_d((Entity)dropItem);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 0) {
            return this.l("tq");
        }
        if (args.length == 1) {
            return ToroQuestCommand.func_71530_a((String[])args, (String[])new String[]{"rep", "gen", "gui", "quest", "list", "book"});
        }
        if (args.length == 2) {
            if ("gen".equals(args[0])) {
                return ToroQuestCommand.func_71530_a((String[])args, (String[])new String[]{"throne_room", "mage_tower", "bastions_lair", "monolith", "graveyard"});
            }
            if ("gui".equals(args[0])) {
                return ToroQuestCommand.func_71530_a((String[])args, (String[])new String[]{"lord"});
            }
            if ("quest".equals(args[0])) {
                return ToroQuestCommand.func_71530_a((String[])args, (String[])new String[]{"current", "complete", "list", "next", "accept", "reject"});
            }
            if ("rep".equals(args[0])) {
                return this.l("10");
            }
        } else if (args.length == 3) {
            if ("rep".equals(args[0])) {
                return ToroQuestCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
        } else if (args.length == 4 && "rep".equals(args[0])) {
            return ToroQuestCommand.func_175762_a((String[])args, Arrays.asList(CivilizationType.values()));
        }
        return this.l(new String[0]);
    }

    private <T> List<T> l(T ... items) {
        ArrayList<T> l = new ArrayList<T>();
        for (T item : items) {
            l.add(item);
        }
        return l;
    }
}

