/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.toroquest;

import java.util.List;
import net.minecraft.block.BlockBush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.torocraft.toroquest.entities.EntityToro;
import net.torocraft.toroquest.network.ToroQuestPacketHandler;
import net.torocraft.toroquest.network.message.MessageRequestPlayerCivilizationSync;
import net.torocraft.toroquest.util.TaskRunner;

public class EventHandlers {
    @SubscribeEvent
    public void handleWorldTick(TickEvent.WorldTickEvent event) {
    }

    @SubscribeEvent
    public void handleWorldTick2(TickEvent.ClientTickEvent event) {
        TaskRunner.run();
    }

    @SubscribeEvent
    public void spawnToroWhenCowPackSpawns(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity == null || !(entity instanceof EntityCow)) {
            return;
        }
        if (entity.getEntityData().func_74767_n("AddedToWorld")) {
            return;
        }
        entity.getEntityData().func_74757_a("AddedToWorld", true);
        World world = event.getWorld();
        if (world.field_73012_v.nextInt(8) != 0) {
            return;
        }
        BlockPos spawnPoint = this.findSurface(world, entity.func_180425_c());
        if (spawnPoint == null) {
            return;
        }
        EntityToro toro = new EntityToro(world);
        toro.func_70107_b(spawnPoint.func_177958_n(), spawnPoint.func_177956_o() + 1, spawnPoint.func_177952_p());
        world.func_72838_d((Entity)toro);
    }

    @SubscribeEvent
    public void toroDontLikeYouHurtingCows(LivingHurtEvent event) {
        EntityLivingBase victim = event.getEntityLiving();
        EntityLivingBase attacker = this.getAttacker(event);
        if (victim == null || attacker == null || !(victim instanceof EntityCow)) {
            return;
        }
        List nearbyToros = victim.func_130014_f_().func_72872_a(EntityToro.class, victim.func_174813_aQ().func_72321_a(40.0, 10.0, 40.0));
        for (EntityToro toro : nearbyToros) {
            toro.func_70624_b(attacker);
        }
    }

    private EntityLivingBase getAttacker(LivingHurtEvent event) {
        try {
            return (EntityLivingBase)event.getSource().func_76346_g();
        }
        catch (Exception e) {
            return null;
        }
    }

    private BlockPos findSurface(World world, BlockPos start) {
        int minY = world.func_72940_L();
        for (int y = world.func_72940_L(); y > 0; --y) {
            BlockPos pos = new BlockPos(start.func_177958_n(), y, start.func_177952_p());
            IBlockState blockState = world.func_180495_p(pos);
            if (this.isLiquid(blockState)) {
                return null;
            }
            if (!this.isGroundBlock(blockState)) continue;
            if (y >= minY) break;
            minY = y;
            break;
        }
        return new BlockPos(start.func_177958_n(), minY, start.func_177952_p());
    }

    private boolean isLiquid(IBlockState blockState) {
        return blockState.func_177230_c() == Blocks.field_150355_j || blockState.func_177230_c() == Blocks.field_150353_l;
    }

    private boolean isGroundBlock(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_150362_t || blockState.func_177230_c() == Blocks.field_150361_u || blockState.func_177230_c() == Blocks.field_150364_r || blockState.func_177230_c() instanceof BlockBush) {
            return false;
        }
        return blockState.func_185914_p();
    }

    public static class SyncTask
    implements Runnable {
        @Override
        public void run() {
            ToroQuestPacketHandler.INSTANCE.sendToServer((IMessage)new MessageRequestPlayerCivilizationSync());
        }
    }
}

