/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.lunarevents;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.capabilities.NyxWorld;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class LunarEvent
implements INBTSerializable<NBTTagCompound> {
    public final String name;
    protected final NyxWorld nyxWorld;
    protected final World world;

    public LunarEvent(String name, NyxWorld nyxWorld) {
        this.name = name;
        this.nyxWorld = nyxWorld;
        this.world = nyxWorld.world;
    }

    public abstract ITextComponent getStartMessage();

    public abstract boolean shouldStart(boolean var1);

    public abstract boolean shouldStop(boolean var1);

    public int getSkyColor() {
        return 0;
    }

    public String getMoonTexture() {
        return null;
    }

    public void update(boolean lastDaytime) {
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public class ConfigImpl
    implements INBTSerializable<NBTTagCompound> {
        public final Supplier<Config.LunarEventConfig> config;
        public int daysSinceLast;
        public int startDays;
        public int graceDays;

        public ConfigImpl(Supplier<Config.LunarEventConfig> config) {
            this.config = config;
        }

        public void update(boolean lastDaytime) {
            if (LunarEvent.this.nyxWorld.currentEvent == LunarEvent.this) {
                this.daysSinceLast = 0;
                this.graceDays = 0;
            }
            if (!lastDaytime && LunarEvent.this.world.func_72935_r()) {
                ++this.daysSinceLast;
                if (this.startDays < this.config.get().startNight) {
                    ++this.startDays;
                }
                if (this.graceDays < this.config.get().graceDays) {
                    ++this.graceDays;
                }
            }
        }

        public boolean canStart() {
            if (LunarEvent.this.nyxWorld.forcedEvent == LunarEvent.this) {
                return true;
            }
            if (this.startDays < this.config.get().startNight) {
                return false;
            }
            if (this.graceDays < this.config.get().graceDays) {
                return false;
            }
            if (this.config.get().nightInterval > 0) {
                return this.daysSinceLast >= this.config.get().nightInterval;
            }
            return LunarEvent.this.world.field_73012_v.nextDouble() <= this.config.get().chance;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("days_since_last", this.daysSinceLast);
            compound.func_74768_a("start_days", this.startDays);
            compound.func_74768_a("grace_days", this.graceDays);
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            this.daysSinceLast = compound.func_74762_e("days_since_last");
            this.startDays = compound.func_74762_e("start_days");
            this.graceDays = compound.func_74762_e("grace_days");
        }
    }
}

