/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.events;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.Registry;
import de.ellpeck.nyx.capabilities.NyxWorld;
import de.ellpeck.nyx.entities.CauldronTracker;
import de.ellpeck.nyx.entities.FallingStar;
import de.ellpeck.nyx.entities.WolfAiSpecialMoon;
import de.ellpeck.nyx.lunarevents.BloodMoon;
import de.ellpeck.nyx.lunarevents.FullMoon;
import de.ellpeck.nyx.lunarevents.HarvestMoon;
import de.ellpeck.nyx.lunarevents.StarShower;
import de.ellpeck.nyx.network.PacketHandler;
import de.ellpeck.nyx.network.PacketNyxWorld;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="nyx")
public final class Events {
    private static final Method SET_SLIME_SIZE_METHOD = ObfuscationReflectionHelper.findMethod(EntitySlime.class, (String)"func_70799_a", Void.TYPE, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        String dimension;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        NyxWorld data = NyxWorld.get(event.world);
        if (data == null) {
            return;
        }
        data.update();
        if (!event.world.field_72995_K && Config.fallingStars && !event.world.func_72935_r() && event.world.func_82737_E() % 20L == 0L && Config.allowedDimensions.contains(dimension = event.world.field_73011_w.func_186058_p().func_186065_b())) {
            for (EntityPlayer player : event.world.field_73010_i) {
                float chanceMult;
                float f = chanceMult = data.currentEvent instanceof StarShower ? 15.0f : 1.0f;
                if ((double)event.world.field_73012_v.nextFloat() > Config.fallingStarRarity * (double)chanceMult) continue;
                BlockPos startPos = player.func_180425_c().func_177963_a(event.world.field_73012_v.nextGaussian() * 20.0, 0.0, event.world.field_73012_v.nextGaussian() * 20.0);
                startPos = event.world.func_175645_m(startPos).func_177981_b(MathHelper.func_76136_a((Random)event.world.field_73012_v, (int)32, (int)64));
                FallingStar star = new FallingStar(event.world);
                star.func_70107_b(startPos.func_177958_n(), startPos.func_177956_o(), startPos.func_177952_p());
                event.world.func_72838_d((Entity)star);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (Config.bloodMoonVanish && !entity.field_70170_p.field_72995_K && entity.field_70170_p.func_72935_r() && entity.getEntityData().func_74767_n("nyx:blood_moon_spawn")) {
            ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.SMOKE_LARGE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 10, 0.5, 1.0, 0.5, 0.0, new int[0]);
            entity.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        NyxWorld nyx = NyxWorld.get(world);
        if (nyx == null) {
            return;
        }
        if (entity instanceof EntityPlayerMP) {
            PacketNyxWorld packet = new PacketNyxWorld(nyx);
            PacketHandler.sendTo((EntityPlayer)((EntityPlayerMP)entity), packet);
        } else if (entity instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)entity;
            wolf.field_70715_bh.func_75776_a(3, (EntityAIBase)new WolfAiSpecialMoon((EntityTameable)wolf));
        }
    }

    @SubscribeEvent
    public static void onExpDrop(LivingExperienceDropEvent event) {
        if (Config.enchantments && Config.lunarEdgeXp) {
            EntityPlayer player = event.getAttackingPlayer();
            if (player == null) {
                return;
            }
            ItemStack held = player.func_184614_ca();
            int level = EnchantmentHelper.func_77506_a((Enchantment)Registry.lunarEdge, (ItemStack)held);
            if (level <= 0) {
                return;
            }
            float exp = event.getDroppedExperience();
            float mod = 2.0f * ((float)level / (float)Registry.lunarEdge.func_77325_b());
            event.setDroppedExperience(MathHelper.func_76141_d((float)(exp * mod)));
        }
    }

    @SubscribeEvent
    public static void onEntityDrop(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        List drops = event.getDrops();
        if (entity instanceof EntityElderGuardian && !entity.field_70170_p.field_72995_K && entity.field_70170_p.field_73012_v.nextDouble() <= Config.cometShardGuardianChance) {
            ItemStack stack = new ItemStack(Registry.cometShard, event.getLootingLevel() / 2 + 1);
            drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack));
        }
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        NyxWorld nyx;
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof IMob) || entity instanceof EntitySlime) {
            return;
        }
        if (event.getSpawner() == null && (nyx = NyxWorld.get(entity.field_70170_p)) != null && nyx.currentEvent instanceof HarvestMoon) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onSpawn(LivingSpawnEvent.SpecialSpawn event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof IMob)) {
            return;
        }
        NyxWorld nyx = NyxWorld.get(entity.field_70170_p);
        if (nyx == null) {
            return;
        }
        if (entity instanceof EntitySlime) {
            int i;
            EntitySlime slime = (EntitySlime)entity;
            int size = slime.func_70809_q();
            if (nyx.currentEvent instanceof FullMoon) {
                i = slime.field_70170_p.field_73012_v.nextInt(5);
                if (i <= 1) {
                    size += 2;
                }
                if (i <= 2) {
                    size += 2;
                }
            } else if (nyx.currentEvent instanceof HarvestMoon && (i = slime.field_70170_p.field_73012_v.nextInt(15)) < 8) {
                size += i * 2;
            }
            if (size != slime.func_70809_q()) {
                try {
                    SET_SLIME_SIZE_METHOD.invoke((Object)slime, size, true);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                event.setCanceled(true);
            }
        }
        if (nyx.currentEvent instanceof FullMoon) {
            if (Config.addPotionEffects && !(entity instanceof EntityCreeper)) {
                Potion effect = null;
                int i = entity.field_70170_p.field_73012_v.nextInt(20);
                if (i <= 2) {
                    effect = MobEffects.field_76424_c;
                } else if (i <= 4) {
                    effect = MobEffects.field_76420_g;
                } else if (i <= 6) {
                    effect = MobEffects.field_76428_l;
                } else if (i <= 7) {
                    effect = MobEffects.field_76441_p;
                }
                if (effect != null) {
                    entity.func_70690_d(new PotionEffect(effect, Integer.MAX_VALUE));
                }
            }
            if (Config.additionalMobsChance > 0 && entity.field_70170_p.field_73012_v.nextInt(Config.additionalMobsChance) == 0) {
                Events.doExtraSpawn((Entity)entity, "full_moon_spawn");
            }
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("nyx".equals(event.getModID())) {
            Config.load();
        }
    }

    @SubscribeEvent
    public static void onInteract(PlayerInteractEvent.RightClickBlock event) {
        FluidStack fluid;
        ItemStack holding;
        int level;
        long time;
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        NyxWorld nyx = NyxWorld.get(world);
        if (Config.disallowDayEnchanting && ((time = world.func_72820_D() % 24000L) <= 13000L || time >= 23000L) && block instanceof BlockEnchantmentTable) {
            event.setUseBlock(Event.Result.DENY);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.nyx.day_enchanting", new Object[0]), true);
        }
        if (Config.lunarWater && block instanceof BlockCauldron && (level = ((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)).intValue()) <= 0 && !(holding = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && (fluid = FluidUtil.getFluidContained((ItemStack)holding)) != null && fluid.getFluid() == Registry.lunarWaterFluid && fluid.amount >= 1000) {
            level = 3;
            if (!world.field_72995_K) {
                player.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151133_ar));
                world.func_175656_a(pos, Registry.lunarWaterCauldron.func_176223_P().func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(level)));
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        }
        if (nyx != null && nyx.currentEvent instanceof BloodMoon && !Config.bloodMoonSleeping && block instanceof BlockBed) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("info.nyx.blood_moon_sleeping", new Object[0]), true);
        }
    }

    @SubscribeEvent
    public static void onBlockChanged(BlockEvent.NeighborNotifyEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block instanceof BlockCauldron)) {
            return;
        }
        if (!world.func_72872_a(CauldronTracker.class, new AxisAlignedBB(pos)).isEmpty()) {
            return;
        }
        CauldronTracker tracker = new CauldronTracker(world);
        tracker.setTrackingPos(pos);
        world.func_72838_d((Entity)tracker);
    }

    @SubscribeEvent
    public static void onWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("nyx", "world_cap"), (ICapabilityProvider)new NyxWorld((World)event.getObject()));
    }

    @SubscribeEvent
    public static void onSleep(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        NyxWorld nyx = NyxWorld.get(player.field_70170_p);
        if (nyx != null && nyx.currentEvent instanceof BloodMoon && !Config.bloodMoonSleeping) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
        }
    }

    private static void doExtraSpawn(Entity original, String key) {
        ResourceLocation name;
        String addedSpawnKey = "nyx:" + key;
        if (!original.getEntityData().func_74767_n(addedSpawnKey) && (name = EntityList.func_191301_a((Entity)original)) != null) {
            boolean listed = Config.mobDuplicationBlacklist.contains(name.toString());
            if (Config.isMobDuplicationWhitelist != listed) {
                return;
            }
            for (int x = -2; x <= 2; ++x) {
                for (int y = -2; y <= 2; ++y) {
                    for (int z = -2; z <= 2; ++z) {
                        BlockPos offset;
                        if (x == 0 && y == 0 && z == 0 || !WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)original.field_70170_p, (BlockPos)(offset = original.func_180425_c().func_177982_a(x, y, z)))) continue;
                        Entity entity = EntityList.func_188429_b((ResourceLocation)name, (World)original.field_70170_p);
                        if (!(entity instanceof EntityLiving)) {
                            return;
                        }
                        EntityLiving living = (EntityLiving)entity;
                        entity.func_70012_b(original.field_70165_t + (double)x, original.field_70163_u + (double)y, original.field_70161_v + (double)z, MathHelper.func_76142_g((float)(original.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                        living.field_70759_as = living.field_70177_z;
                        living.field_70761_aq = living.field_70177_z;
                        living.getEntityData().func_74757_a(addedSpawnKey, true);
                        if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)living, (World)original.field_70170_p, (float)((float)original.field_70165_t + (float)x), (float)((float)original.field_70163_u + (float)y), (float)((float)original.field_70161_v + (float)z), null)) {
                            living.func_180482_a(original.field_70170_p.func_175649_E(new BlockPos((Entity)living)), null);
                        }
                        original.field_70170_p.func_72838_d(entity);
                        return;
                    }
                }
            }
        }
    }
}

