/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.entities;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.Registry;
import de.ellpeck.nyx.blocks.LunarWaterCauldron;
import de.ellpeck.nyx.capabilities.NyxWorld;
import de.ellpeck.nyx.lunarevents.FullMoon;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CauldronTracker
extends Entity {
    private static final DataParameter<Boolean> IS_DONE = EntityDataManager.func_187226_a(CauldronTracker.class, (DataSerializer)DataSerializers.field_187198_h);
    private BlockPos trackingPos;
    private int timer;

    public CauldronTracker(World worldIn) {
        super(worldIn);
        this.func_174826_a(null);
    }

    public void setTrackingPos(BlockPos pos) {
        this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        this.trackingPos = pos;
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70030_z() {
        if (this.field_70170_p.field_72995_K) {
            if (((Boolean)this.field_70180_af.func_187225_a(IS_DONE)).booleanValue() && this.field_70170_p.field_73012_v.nextBoolean()) {
                double x = (double)this.field_70170_p.field_73012_v.nextFloat() + this.field_70165_t - 0.5;
                double z = (double)this.field_70170_p.field_73012_v.nextFloat() + this.field_70161_v - 0.5;
                this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, x, this.field_70163_u + 0.25, z, 1.0, 1.0, 1.0, new int[0]);
            }
            return;
        }
        IBlockState state = this.field_70170_p.func_180495_p(this.trackingPos);
        Block block = state.func_177230_c();
        if (!(block instanceof BlockCauldron) || block instanceof LunarWaterCauldron) {
            this.func_70106_y();
            return;
        }
        int level = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
        if (level <= 0) {
            if (this.timer > 0) {
                this.field_70180_af.func_187227_b(IS_DONE, (Object)false);
                this.timer = 0;
            }
            return;
        }
        if (!((Boolean)this.field_70180_af.func_187225_a(IS_DONE)).booleanValue()) {
            NyxWorld nyx = NyxWorld.get(this.field_70170_p);
            if (nyx == null || !(nyx.currentEvent instanceof FullMoon) || !this.field_70170_p.func_175678_i(this.trackingPos)) {
                this.timer = 0;
                return;
            }
            ++this.timer;
            if (this.timer >= Config.nightTicks) {
                this.field_70180_af.func_187227_b(IS_DONE, (Object)true);
            }
        } else {
            List items = this.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(this.trackingPos));
            for (EntityItem item : items) {
                ItemStack stack;
                if (item.field_70128_L || (stack = item.func_92059_d()).func_77973_b() != Items.field_151100_aR || stack.func_77960_j() != EnumDyeColor.BLUE.func_176767_b()) continue;
                item.func_70106_y();
                IBlockState newState = Registry.lunarWaterCauldron.func_176223_P().func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(level));
                this.field_70170_p.func_175656_a(this.trackingPos, newState);
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, Registry.lunarWaterSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.func_70106_y();
            }
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setTrackingPos(NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("tracking_pos")));
        this.timer = compound.func_74762_e("timer");
        this.field_70180_af.func_187227_b(IS_DONE, (Object)compound.func_74767_n("done"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("tracking_pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.trackingPos));
        compound.func_74768_a("timer", this.timer);
        compound.func_74757_a("done", ((Boolean)this.field_70180_af.func_187225_a(IS_DONE)).booleanValue());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_DONE, (Object)false);
    }
}

