/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.capabilities;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.Registry;
import de.ellpeck.nyx.lunarevents.BloodMoon;
import de.ellpeck.nyx.lunarevents.FullMoon;
import de.ellpeck.nyx.lunarevents.HarvestMoon;
import de.ellpeck.nyx.lunarevents.LunarEvent;
import de.ellpeck.nyx.lunarevents.StarShower;
import de.ellpeck.nyx.network.PacketHandler;
import de.ellpeck.nyx.network.PacketNyxWorld;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class NyxWorld
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    public static float moonPhase;
    public final World world;
    public final List<LunarEvent> lunarEvents = new ArrayList<LunarEvent>();
    public float eventSkyModifier;
    public int currentSkyColor;
    public LunarEvent currentEvent;
    public LunarEvent forcedEvent;
    private boolean wasDaytime;

    public NyxWorld(World world) {
        this.world = world;
        this.lunarEvents.add(new HarvestMoon(this));
        this.lunarEvents.add(new StarShower(this));
        this.lunarEvents.add(new BloodMoon(this));
        this.lunarEvents.add(new FullMoon(this));
    }

    public void update() {
        String dimension = this.world.field_73011_w.func_186058_p().func_186065_b();
        if (!Config.allowedDimensions.contains(dimension)) {
            return;
        }
        moonPhase = this.world.func_130001_d();
        for (LunarEvent lunarEvent : this.lunarEvents) {
            lunarEvent.update(this.wasDaytime);
        }
        if (!this.world.field_72995_K) {
            boolean isDirty = false;
            if (this.currentEvent == null) {
                if (this.forcedEvent != null && this.forcedEvent.shouldStart(this.wasDaytime)) {
                    this.currentEvent = this.forcedEvent;
                    this.forcedEvent = null;
                } else {
                    for (LunarEvent lunarEvent : this.lunarEvents) {
                        if (!lunarEvent.shouldStart(this.wasDaytime)) continue;
                        this.currentEvent = lunarEvent;
                        break;
                    }
                }
                if (this.currentEvent != null) {
                    isDirty = true;
                    ITextComponent iTextComponent = this.currentEvent.getStartMessage();
                    for (EntityPlayer player : this.world.field_73010_i) {
                        player.func_145747_a(iTextComponent);
                    }
                }
            }
            if (this.currentEvent != null && this.currentEvent.shouldStop(this.wasDaytime)) {
                this.currentEvent = null;
                isDirty = true;
            }
            if (isDirty) {
                for (EntityPlayer entityPlayer : this.world.field_73010_i) {
                    PacketHandler.sendTo(entityPlayer, new PacketNyxWorld(this));
                }
            }
            this.wasDaytime = this.world.func_72935_r();
        } else if (this.currentEvent != null && this.currentSkyColor != 0) {
            if (this.eventSkyModifier < 1.0f) {
                this.eventSkyModifier += 0.01f;
            }
        } else if (this.eventSkyModifier > 0.0f) {
            this.eventSkyModifier -= 0.01f;
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.currentEvent != null) {
            compound.func_74778_a("event", this.currentEvent.name);
        }
        compound.func_74757_a("was_daytime", this.wasDaytime);
        for (LunarEvent event : this.lunarEvents) {
            compound.func_74782_a(event.name, (NBTBase)event.serializeNBT());
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        String name = compound.func_74779_i("event");
        this.currentEvent = this.lunarEvents.stream().filter(e -> e.name.equals(name)).findFirst().orElse(null);
        if (this.currentEvent != null) {
            this.currentSkyColor = this.currentEvent.getSkyColor();
        }
        this.wasDaytime = compound.func_74767_n("was_daytime");
        for (LunarEvent event : this.lunarEvents) {
            event.deserializeNBT(compound.func_74775_l(event.name));
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Registry.worldCapability;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Registry.worldCapability ? this : null);
    }

    public static NyxWorld get(World world) {
        if (world.hasCapability(Registry.worldCapability, null)) {
            return (NyxWorld)world.getCapability(Registry.worldCapability, null);
        }
        return null;
    }
}

