/*
 * Decompiled with CFR 0.152.
 */
package kenkron.antiqueatlasoverlay;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

class SetTileRenderer {
    private final HashMap<ResourceLocation, ArrayList<TileCorner>> subjects = new HashMap();
    private int tileHalfSize = 8;

    public SetTileRenderer(int tileHalfSize) {
        this.tileHalfSize = tileHalfSize;
    }

    public void addTileCorner(ResourceLocation texture, int x, int y, int u, int v) {
        ArrayList set = this.subjects.computeIfAbsent(texture, k -> new ArrayList());
        set.add(new TileCorner(x, y, u, v));
    }

    public void draw() {
        for (ResourceLocation key : this.subjects.keySet()) {
            ArrayList<TileCorner> tca = this.subjects.get(key);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(key);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder renderer = tessellator.func_178180_c();
            renderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (TileCorner tc : tca) {
                this.drawInlineAutotileCorner(tc.x, tc.y, tc.u, tc.v);
            }
            tessellator.func_78381_a();
        }
    }

    private void drawInlineAutotileCorner(int x, int y, int u, int v) {
        float minU = (float)u / 4.0f;
        float maxU = (float)(u + 1) / 4.0f;
        float minV = (float)v / 6.0f;
        float maxV = (float)(v + 1) / 6.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181662_b((double)(x + this.tileHalfSize), (double)(y + this.tileHalfSize), 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        renderer.func_181662_b((double)(x + this.tileHalfSize), (double)y, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        renderer.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + this.tileHalfSize), 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
    }

    public class TileCorner {
        final int x;
        final int y;
        final int u;
        final int v;

        TileCorner(int x, int y, int u, int v) {
            this.x = x;
            this.y = y;
            this.u = u;
            this.v = v;
        }
    }
}

