/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext.watcher.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.SettingsConfig;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.event.OptionalMarkerEvent;
import hunternif.mc.atlas.ext.ExtTileIdMap;
import hunternif.mc.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.atlas.ext.watcher.StructureWatcher;
import hunternif.mc.atlas.ext.watcher.WatcherPos;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.registry.MarkerTypes;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.MathUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcherVillage
implements IStructureWatcher {
    public static final String MARKER = "village";
    private static final String LIBRARY = "ViBH";
    private static final String SMITHY = "ViS";
    private static final String L_HOUSE = "ViTRH";
    private static final String FARMLAND_LARGE = "ViDF";
    private static final String FARMLAND_SMALL = "ViF";
    private static final String PATH = "ViSR";
    private static final String TORCH = "ViL";
    private static final String WELL = "ViW";
    private static final String START = "ViStart";
    private static final String BUTCHERS = "ViPH";
    private static final String HUT = "ViSmH";
    private static final String HOUSE_SMALL = "ViSH";
    private static final String CHURCH = "ViST";
    private static final Map<String, String> partToTileMap;
    private static final Map<String, Integer> tilePriority;
    private final Set<WatcherPos> visited = new HashSet<WatcherPos>();

    public StructureWatcherVillage() {
        StructureWatcher.INSTANCE.addWatcher(this);
    }

    @Override
    @Nonnull
    public Set<WatcherPos> getVisited() {
        return this.visited;
    }

    @Override
    public boolean isDimensionValid(DimensionType type) {
        return type.func_186068_a() == 0;
    }

    @SubscribeEvent
    public void onOptionalMarker(OptionalMarkerEvent event) {
        if (event.type == MarkerTypes.VILLAGE && !SettingsConfig.gameplay.autoVillageMarkers) {
            event.setCanceled(true);
        }
    }

    @Override
    @Nullable
    public NBTTagCompound getStructureData(@Nonnull World world) {
        MapGenStructureData data = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Village");
        if (data == null) {
            return null;
        }
        return data.func_143041_a();
    }

    @Override
    @Nonnull
    public Set<Pair<WatcherPos, String>> visitStructure(@Nonnull World world, @Nonnull NBTTagCompound structureTag) {
        Set tagSet = structureTag.func_150296_c();
        HashSet visits = Sets.newHashSet();
        for (String coords : tagSet) {
            WatcherPos pos;
            if (!WatcherPos.POS_PATTERN.matcher(coords).matches() || this.visited.contains(pos = new WatcherPos(coords))) continue;
            NBTTagCompound tag = structureTag.func_74775_l(coords);
            this.visitVillage(world, tag);
            this.visited.add(pos);
            visits.add(Pair.of((Object)pos, (Object)"Village"));
        }
        return visits;
    }

    private void visitVillage(World world, NBTTagCompound tag) {
        if (!tag.func_74767_n("Valid")) {
            StructureWatcherVillage.removeVillage(world, tag);
            return;
        }
        NBTTagList children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.func_74745_c(); ++i) {
            String tileName;
            NBTTagCompound child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            StructureBoundingBox boundingBox = new StructureBoundingBox(child.func_74759_k("BB"));
            int x = MathUtil.getCenter(boundingBox).func_177958_n();
            int z = MathUtil.getCenter(boundingBox).func_177952_p();
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (START.equals(childID)) {
                boolean foundMarker = false;
                for (int j = -1; j <= 1; ++j) {
                    block2: for (int k = -1; k <= 1; ++k) {
                        List<Marker> markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk(world.field_73011_w.getDimension(), j + chunkX / 8, k + chunkZ / 8);
                        if (markers == null) continue;
                        for (Marker marker : markers) {
                            if (!marker.isOfType(MarkerTypes.VILLAGE)) continue;
                            foundMarker = true;
                            continue block2;
                        }
                    }
                }
                if (!foundMarker && SettingsConfig.gameplay.autoVillageMarkers) {
                    AtlasAPI.markers.putGlobalMarker(world, false, MarkerTypes.VILLAGE, "gui.antiqueatlas.marker.village", x, z);
                }
            }
            if ((tileName = partToTileMap.get(childID)) == null) continue;
            Integer curTilePriority = tilePriority.get(tileName);
            Integer prevTilePriority = tilePriority.get(StructureWatcherVillage.tileAt(chunkX, chunkZ));
            if (curTilePriority != null && prevTilePriority != null) {
                if (curTilePriority < prevTilePriority) continue;
                AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ);
                continue;
            }
            AtlasAPI.tiles.putCustomGlobalTile(world, tileName, chunkX, chunkZ);
        }
    }

    private static String tileAt(int chunkX, int chunkZ) {
        int biomeID = AntiqueAtlasMod.extBiomeData.getData().getBiomeIdAt(0, chunkX, chunkZ);
        return ExtTileIdMap.instance().getPseudoBiomeName(biomeID);
    }

    private static void removeVillage(World world, NBTTagCompound tag) {
        NBTTagList children = tag.func_150295_c("Children", 10);
        for (int i = 0; i < children.func_74745_c(); ++i) {
            List<Marker> markers;
            NBTTagCompound child = children.func_150305_b(i);
            String childID = child.func_74779_i("id");
            StructureBoundingBox boundingBox = new StructureBoundingBox(child.func_74759_k("BB"));
            int x = MathUtil.getCenter(boundingBox).func_177958_n();
            int z = MathUtil.getCenter(boundingBox).func_177952_p();
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (START.equals(childID) && (markers = AntiqueAtlasMod.globalMarkersData.getData().getMarkersAtChunk(world.field_73011_w.getDimension(), chunkX / 8, chunkZ / 8)) != null) {
                for (Marker marker : markers) {
                    if (!marker.isOfType(MarkerTypes.VILLAGE)) continue;
                    AtlasAPI.markers.deleteGlobalMarker(world, marker.getId());
                    Log.info("Removed faux village marker", new Object[0]);
                    break;
                }
            }
            AtlasAPI.tiles.deleteCustomGlobalTile(world, chunkX, chunkZ);
            Log.info("Removed faux village tile", new Object[0]);
        }
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)LIBRARY, (Object)"npcVillageLibrary");
        builder.put((Object)SMITHY, (Object)"npcVillageSmithy");
        builder.put((Object)L_HOUSE, (Object)"npcVillageLHouse");
        builder.put((Object)FARMLAND_LARGE, (Object)"npcVillageFarmlandLarge");
        builder.put((Object)FARMLAND_SMALL, (Object)"npcVillageFarmlandSmall");
        builder.put((Object)TORCH, (Object)"npcVillageTorch");
        builder.put((Object)WELL, (Object)"npcVillageWell");
        builder.put((Object)START, (Object)"npcVillageWell");
        builder.put((Object)BUTCHERS, (Object)"npcVillageButchersShop");
        builder.put((Object)HOUSE_SMALL, (Object)"npcVillageSmallHouse");
        builder.put((Object)HUT, (Object)"npcVillageHut");
        builder.put((Object)CHURCH, (Object)"npcVillageChurch");
        partToTileMap = builder.build();
        builder = new ImmutableMap.Builder();
        builder.put((Object)"npcVillageLibrary", (Object)5);
        builder.put((Object)"npcVillageSmithy", (Object)6);
        builder.put((Object)"npcVillageLHouse", (Object)5);
        builder.put((Object)"npcVillageFarmlandLarge", (Object)3);
        builder.put((Object)"npcVillageFarmlandSmall", (Object)3);
        builder.put((Object)"npcVillageTorch", (Object)1);
        builder.put((Object)"npcVillageWell", (Object)7);
        builder.put((Object)"npcVillageButchersShop", (Object)4);
        builder.put((Object)"npcVillageSmallHouse", (Object)4);
        builder.put((Object)"npcVillageHut", (Object)3);
        builder.put((Object)"npcVillageChurch", (Object)6);
        tilePriority = builder.build();
    }
}

