/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.CoreModManager;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.LibBase;

public class ReflectedField {
    protected static boolean isDeobfuscatedEnvironment = false;
    protected final String className;
    protected final String fieldName;
    protected final Field field;

    protected ReflectedField(@Nonnull String className, @Nonnull String fieldName, @Nullable String obfName) {
        this.className = className;
        this.fieldName = fieldName;
        this.field = ReflectedField.resolve(className, fieldName, obfName);
    }

    protected ReflectedField(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nullable String obfName) {
        Preconditions.checkNotNull(clazz);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fieldName), (Object)"Field name cannot be empty");
        this.className = clazz.getName();
        this.fieldName = fieldName;
        this.field = ReflectedField.resolve(clazz, fieldName, obfName);
    }

    @Nullable
    private static Field resolve(@Nonnull String className, @Nonnull String fieldName, @Nullable String obfName) {
        try {
            return ReflectedField.resolve(Class.forName(className), fieldName, obfName);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    private static Field resolve(@Nonnull Class<?> clazz, @Nonnull String fieldName, @Nullable String obfName) {
        String nameToFind = isDeobfuscatedEnvironment ? fieldName : (String)MoreObjects.firstNonNull((Object)obfName, (Object)fieldName);
        try {
            Field f = clazz.getDeclaredField(nameToFind);
            f.setAccessible(true);
            return f;
        }
        catch (Throwable t) {
            String msg = String.format("Unable to locate field [%s::%s]", clazz.getName(), nameToFind);
            LibBase.log().warn(msg, new Object[0]);
            return null;
        }
    }

    public boolean isAvailable() {
        return this.field != null;
    }

    protected void check() {
        if (!this.isAvailable()) {
            String msg = String.format("Uninitialized field [%s::%s]", this.className, this.fieldName);
            throw new IllegalStateException(msg);
        }
    }

    protected void report(@Nonnull Throwable t) {
        String msg = String.format("Unable to access field [%s::%s]", this.className, this.fieldName);
        LibBase.log().error(msg, t);
    }

    @Nullable
    public static Class<?> resolveClass(@Nonnull String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static {
        try {
            Field f = CoreModManager.class.getDeclaredField("deobfuscatedEnvironment");
            f.setAccessible(true);
            isDeobfuscatedEnvironment = f.getBoolean(null);
        }
        catch (Throwable t) {
            LibBase.log().error("Unable to determine obsfucated environment", t);
        }
    }

    public static class BooleanField<T>
    extends ReflectedField {
        public final boolean defaultValue;

        public BooleanField(@Nonnull Class<T> clazz, @Nonnull String fieldName, @Nonnull String obfName) {
            this(clazz, fieldName, obfName, false);
        }

        public BooleanField(@Nonnull Class<T> clazz, @Nonnull String fieldName, @Nonnull String obfName, boolean defaultValue) {
            super(clazz, fieldName, obfName);
            this.defaultValue = defaultValue;
        }

        public boolean get(@Nullable T obj) {
            this.check();
            try {
                return this.field.getBoolean(obj);
            }
            catch (Throwable t) {
                this.report(t);
                return this.defaultValue;
            }
        }

        public void set(@Nullable T obj, boolean val) {
            this.check();
            try {
                this.field.setBoolean(obj, val);
            }
            catch (Throwable t) {
                this.report(t);
            }
        }
    }

    public static class FloatField<T>
    extends ReflectedField {
        public final float defaultValue;

        public FloatField(@Nonnull String className, @Nonnull String fieldName, @Nonnull String obfName) {
            super(className, fieldName, obfName);
            this.defaultValue = 0.0f;
        }

        public FloatField(@Nonnull Class<T> clazz, @Nonnull String fieldName, @Nonnull String obfName) {
            this(clazz, fieldName, obfName, 0.0f);
        }

        public FloatField(@Nonnull Class<T> clazz, @Nonnull String fieldName, @Nonnull String obfName, float defaultValue) {
            super(clazz, fieldName, obfName);
            this.defaultValue = defaultValue;
        }

        public float get(@Nullable T obj) {
            this.check();
            try {
                return this.field.getFloat(obj);
            }
            catch (Throwable t) {
                this.report(t);
                return this.defaultValue;
            }
        }

        public void set(@Nullable T obj, float val) {
            this.check();
            try {
                this.field.setFloat(obj, val);
            }
            catch (Throwable t) {
                this.report(t);
            }
        }
    }

    public static class IntegerField<T>
    extends ReflectedField {
        public final int defaultValue;

        public IntegerField(@Nonnull String className, @Nonnull String fieldName, @Nonnull String obfName) {
            super(className, fieldName, obfName);
            this.defaultValue = 0;
        }

        public IntegerField(@Nonnull Class<T> clazz, @Nonnull String fieldName, @Nonnull String obfName) {
            this(clazz, fieldName, obfName, 0);
        }

        public IntegerField(@Nonnull Class<T> clazz, @Nonnull String fieldName, @Nonnull String obfName, int defaultValue) {
            super(clazz, fieldName, obfName);
            this.defaultValue = defaultValue;
        }

        public int get(@Nullable T obj) {
            this.check();
            try {
                return this.field.getInt(obj);
            }
            catch (Throwable t) {
                this.report(t);
                return this.defaultValue;
            }
        }

        public void set(@Nullable T obj, int val) {
            this.check();
            try {
                this.field.setInt(obj, val);
            }
            catch (Throwable t) {
                this.report(t);
            }
        }
    }

    public static class ObjectField<T, R>
    extends ReflectedField {
        public final R defaultValue;

        public ObjectField(@Nonnull String className, @Nonnull String fieldName, @Nonnull String obfName) {
            super(className, fieldName, obfName);
            this.defaultValue = null;
        }

        public ObjectField(@Nonnull Class<T> clazz, @Nonnull String fieldName, @Nonnull String obfName) {
            this(clazz, fieldName, obfName, null);
        }

        public ObjectField(@Nonnull Class<T> clazz, @Nonnull String fieldName, @Nonnull String obfName, @Nullable R defaultValue) {
            super(clazz, fieldName, obfName);
            this.defaultValue = defaultValue;
        }

        public R get(@Nullable T obj) {
            this.check();
            Object result = null;
            try {
                result = this.field.get(obj);
            }
            catch (Throwable t) {
                this.report(t);
            }
            return (R)(result == null ? this.defaultValue : result);
        }

        public void set(@Nullable T obj, @Nullable Object val) {
            this.check();
            try {
                this.field.set(obj, val);
            }
            catch (Throwable t) {
                this.report(t);
            }
        }
    }
}

