/*
 * Decompiled with CFR 0.152.
 */
package coolsquid.hungertweaker.util;

import coolsquid.hungertweaker.util.Util;
import crafttweaker.api.data.DataString;
import crafttweaker.api.data.IData;
import java.util.Random;

public interface Expression {
    public double eval(double var1);

    public static Expression parse(IData data) {
        if (Util.isNumber(data)) {
            double d = data.asDouble();
            return x -> d;
        }
        if (data instanceof DataString) {
            return Expression.parse(data.asString());
        }
        throw new IllegalArgumentException("The argument must be a string or a number");
    }

    public static Expression parse(final String str) {
        return new Object(){
            int pos = -1;
            char ch;

            void nextChar() {
                this.ch = (char)(++this.pos < str.length() ? (int)str.charAt(this.pos) : 65535);
            }

            boolean eat(char charToEat) {
                while (this.ch == ' ') {
                    this.nextChar();
                }
                if (this.ch == charToEat) {
                    this.nextChar();
                    return true;
                }
                return false;
            }

            Expression parse() {
                if (str.isEmpty()) {
                    throw new RuntimeException("Cannot create an expression from an empty string");
                }
                this.nextChar();
                Expression e = this.parseExpression();
                if (this.pos < str.length()) {
                    throw new RuntimeException("Unexpected char '" + this.ch + "' at index " + this.pos);
                }
                return e;
            }

            Expression parseExpression() {
                Expression e = this.parseTerm();
                while (true) {
                    Expression b;
                    Expression a;
                    if (this.eat('+')) {
                        a = e;
                        b = this.parseTerm();
                        e = x -> a.eval(x) + b.eval(x);
                        continue;
                    }
                    if (!this.eat('-')) break;
                    a = e;
                    b = this.parseTerm();
                    e = x -> a.eval(x) - b.eval(x);
                }
                return e;
            }

            Expression parseTerm() {
                Expression e = this.parseFactor();
                while (true) {
                    Expression b;
                    Expression a;
                    if (this.eat('*')) {
                        a = e;
                        b = this.parseFactor();
                        e = x -> a.eval(x) * b.eval(x);
                        continue;
                    }
                    if (!this.eat('/')) break;
                    a = e;
                    b = this.parseFactor();
                    e = x -> a.eval(x) / b.eval(x);
                }
                return e;
            }

            Expression nextParameter() {
                if (!this.eat(',')) {
                    throw new RuntimeException("Expected another parameter at index " + this.pos);
                }
                return this.parseExpression();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            Expression parseFactor() {
                Expression e;
                if (this.eat('+')) {
                    return this.parseFactor();
                }
                if (this.eat('-')) {
                    Expression e2 = this.parseFactor();
                    return x -> -e2.eval(x);
                }
                int startPos = this.pos;
                if (this.eat('(')) {
                    e = this.parseExpression();
                    if (!this.eat(')')) {
                        throw new RuntimeException("Expected ')' at index " + this.pos);
                    }
                } else if (this.ch >= '0' && this.ch <= '9' || this.ch == '.') {
                    while (this.ch >= '0' && this.ch <= '9' || this.ch == '.') {
                        this.nextChar();
                    }
                    double d = Double.parseDouble(str.substring(startPos, this.pos));
                    e = x -> d;
                } else {
                    if (this.ch < 'a') throw new RuntimeException("Unexpected char '" + this.ch + "' at index " + this.pos);
                    if (this.ch > 'z') throw new RuntimeException("Unexpected char '" + this.ch + "' at index " + this.pos);
                    while (this.ch >= 'a' && this.ch <= 'z') {
                        this.nextChar();
                    }
                    String func = str.substring(startPos, this.pos);
                    if (this.eat('(')) {
                        Expression a;
                        if (func.equals("random")) {
                            if (this.eat(')')) {
                                e = x -> Math.random();
                            } else {
                                a = e = this.parseExpression();
                                Random random = new Random();
                                e = x -> random.nextInt((int)a.eval(x));
                                if (!this.eat(')')) {
                                    throw new RuntimeException("Expected ')' at index " + this.pos);
                                }
                            }
                        } else {
                            a = e = this.parseExpression();
                            if (func.equals("sqrt")) {
                                e = x -> Math.sqrt(a.eval(x));
                            } else if (func.equals("sin")) {
                                e = x -> Math.sin(Math.toRadians(a.eval(x)));
                            } else if (func.equals("cos")) {
                                e = x -> Math.cos(Math.toRadians(a.eval(x)));
                            } else if (func.equals("tan")) {
                                e = x -> Math.tan(Math.toRadians(a.eval(x)));
                            } else if (func.equals("round")) {
                                e = x -> Math.round(a.eval(x));
                            } else if (func.equals("ceil")) {
                                e = x -> Math.ceil(a.eval(x));
                            } else if (func.equals("nextUp")) {
                                e = x -> Math.nextUp(a.eval(x));
                            } else if (func.equals("nextDown")) {
                                e = x -> Math.nextDown(a.eval(x));
                            } else if (func.equals("max")) {
                                Expression b = this.nextParameter();
                                e = x -> Math.max(a.eval(x), b.eval(x));
                            } else if (func.equals("min")) {
                                Expression b = this.nextParameter();
                                e = x -> Math.min(a.eval(x), b.eval(x));
                            } else {
                                if (!func.equals("clamp")) throw new RuntimeException("Unknown function: " + func);
                                Expression b = this.nextParameter();
                                Expression c = this.nextParameter();
                                e = x -> {
                                    double aa = a.eval(x);
                                    double bb = b.eval(x);
                                    double cc = c.eval(x);
                                    if (aa < bb) {
                                        return bb;
                                    }
                                    if (aa > cc) {
                                        return cc;
                                    }
                                    return aa;
                                };
                            }
                            if (!this.eat(')')) {
                                throw new RuntimeException("Expected ')' at index " + this.pos);
                            }
                        }
                    } else {
                        if (!func.equals("x")) throw new RuntimeException("Expected '(' at index " + this.pos);
                        e = x -> x;
                    }
                }
                if (!this.eat('^')) return e;
                Expression a = e;
                Expression b = this.parseFactor();
                return x -> Math.pow(a.eval(x), b.eval(x));
            }
        }.parse();
    }
}

