/*
 * Decompiled with CFR 0.152.
 */
package coolsquid.hungertweaker.ct;

import coolsquid.hungertweaker.util.Expression;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.potions.IPotionEffect;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import squeek.applecore.api.AppleCoreAPI;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="mods.hungertweaker.FoodValues")
public class CTFoodValues {
    private static final String FIELD_ALWAYS_EDIBLE = "field_77852_bZ";
    private static final String FIELD_WOLF_FOOD = "field_77856_bY";
    private static final String FIELD_EFFECT_PROBABILITY = "field_77858_cd";
    private static final String FIELD_EFFECT = "field_77851_ca";
    public static final List<CTFoodValues> LIST = new ArrayList<CTFoodValues>();
    private static final Map<IIngredient, CTFoodValues> MAP = new HashMap<IIngredient, CTFoodValues>();
    public final IIngredient ingredient;
    public Expression hunger;
    public Expression saturationModifier;

    private CTFoodValues(IIngredient ingredient) {
        this.ingredient = ingredient;
    }

    @ZenSetter(value="hunger")
    @ZenMethod(value="setHunger")
    public void setHunger(IData v) {
        this.hunger = Expression.parse(v);
    }

    @ZenGetter(value="hunger")
    public int getHunger() {
        if (this.ingredient instanceof IItemStack) {
            return AppleCoreAPI.accessor.getFoodValues((ItemStack)CraftTweakerMC.getItemStack((IIngredient)this.ingredient)).hunger;
        }
        throw new RuntimeException("Can only retrieve the hunger value of individual item stacks");
    }

    @ZenSetter(value="saturationModifier")
    @ZenMethod(value="setSaturationModifier")
    public void setSaturationModifier(IData v) {
        this.saturationModifier = Expression.parse(v);
    }

    @ZenGetter(value="saturationModifier")
    public float getSaturationModifier() {
        if (this.ingredient instanceof IItemStack) {
            return AppleCoreAPI.accessor.getFoodValues((ItemStack)CraftTweakerMC.getItemStack((IIngredient)this.ingredient)).saturationModifier;
        }
        throw new RuntimeException("Can only retrieve the saturation value of individual item stacks");
    }

    @ZenGetter(value="unmodifiedHunger")
    public int getUnmodifiedHunger() {
        if (this.ingredient instanceof IItemStack) {
            return AppleCoreAPI.accessor.getUnmodifiedFoodValues((ItemStack)CraftTweakerMC.getItemStack((IIngredient)this.ingredient)).hunger;
        }
        throw new RuntimeException("Can only retrieve the hunger value of individual item stacks");
    }

    @ZenGetter(value="unmodifiedSaturationModifier")
    public float getUnmodifiedSaturationModifier() {
        if (this.ingredient instanceof IItemStack) {
            return AppleCoreAPI.accessor.getUnmodifiedFoodValues((ItemStack)CraftTweakerMC.getItemStack((IIngredient)this.ingredient)).saturationModifier;
        }
        throw new RuntimeException("Can only retrieve the saturation value of individual item stacks");
    }

    @ZenGetter(value="alwaysEdible")
    public boolean isAlwaysEdible() {
        List<ItemFood> itemFoods = this.getItemFoods();
        if (itemFoods.size() == 1) {
            return (Boolean)ObfuscationReflectionHelper.getPrivateValue(ItemFood.class, (Object)itemFoods.get(0), (String)FIELD_ALWAYS_EDIBLE);
        }
        throw new RuntimeException("Can only retrieve the properties of individual item stacks");
    }

    @ZenSetter(value="alwaysEdible")
    public void setAlwaysEdible(boolean b) {
        for (ItemFood itemFood : this.getItemFoods()) {
            ObfuscationReflectionHelper.setPrivateValue(ItemFood.class, (Object)itemFood, (Object)b, (String)FIELD_ALWAYS_EDIBLE);
        }
    }

    @ZenGetter(value="wolfFood")
    public boolean isWolfFood() {
        List<ItemFood> itemFoods = this.getItemFoods();
        if (itemFoods.size() == 1) {
            return (Boolean)ObfuscationReflectionHelper.getPrivateValue(ItemFood.class, (Object)itemFoods.get(0), (String)FIELD_WOLF_FOOD);
        }
        throw new RuntimeException("Can only retrieve the properties of individual item stacks");
    }

    @ZenSetter(value="wolfFood")
    public void setWolfFood(boolean b) {
        try {
            Field field = ObfuscationReflectionHelper.findField(ItemFood.class, (String)FIELD_WOLF_FOOD);
            field.setAccessible(true);
            Field modField = Field.class.getDeclaredField("modifiers");
            modField.setAccessible(true);
            modField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            for (ItemFood itemFood : this.getItemFoods()) {
                field.set(itemFood, b);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @ZenGetter(value="effect")
    public IPotionEffect getEffect() {
        List<ItemFood> itemFoods = this.getItemFoods();
        if (itemFoods.size() == 1) {
            return CraftTweakerMC.getIPotionEffect((PotionEffect)this.getEffectInternal(itemFoods.get(0)));
        }
        throw new RuntimeException("Can only retrieve the properties of individual item stacks");
    }

    @ZenSetter(value="effect")
    public void setEffect(IPotionEffect effect) {
        for (ItemFood itemFood : this.getItemFoods()) {
            float probability = this.getEffectInternal(itemFood) == null ? 1.0f : this.getEffectProbabilityInternal(itemFood);
            itemFood.func_185070_a(CraftTweakerMC.getPotionEffect((IPotionEffect)effect), probability);
        }
    }

    @ZenGetter(value="effectProbability")
    public float getEffectProbability() {
        List<ItemFood> itemFoods = this.getItemFoods();
        if (itemFoods.size() == 1) {
            return ((Float)ObfuscationReflectionHelper.getPrivateValue(ItemFood.class, (Object)itemFoods.get(0), (String)FIELD_EFFECT_PROBABILITY)).floatValue();
        }
        throw new RuntimeException("Can only retrieve the properties of individual item stacks");
    }

    @ZenSetter(value="effectProbability")
    public void setEffectProbability(float f) {
        for (ItemFood itemFood : this.getItemFoods()) {
            itemFood.func_185070_a(this.getEffectInternal(itemFood), f);
        }
    }

    private PotionEffect getEffectInternal(ItemFood itemFood) {
        return (PotionEffect)ObfuscationReflectionHelper.getPrivateValue(ItemFood.class, (Object)itemFood, (String)FIELD_EFFECT);
    }

    private float getEffectProbabilityInternal(ItemFood itemFood) {
        return ((Float)ObfuscationReflectionHelper.getPrivateValue(ItemFood.class, (Object)itemFood, (String)FIELD_EFFECT_PROBABILITY)).floatValue();
    }

    private List<ItemFood> getItemFoods() {
        ArrayList<ItemFood> itemFoods = new ArrayList<ItemFood>();
        List iItemStacks = this.ingredient.getItems();
        if (this.ingredient instanceof IngredientAny) {
            for (Item item : Item.field_150901_e) {
                if (!this.ingredient.matches(CraftTweakerMC.getIItemStack((ItemStack)new ItemStack(item)))) continue;
                if (item instanceof ItemFood) {
                    itemFoods.add((ItemFood)item);
                    continue;
                }
                CraftTweakerAPI.logWarning((String)("Item '" + item + "' in ingredient '" + this.ingredient.toCommandString() + "' is not an ItemFood"));
            }
        } else if (iItemStacks == null) {
            CraftTweakerAPI.logWarning((String)("Ingredient '" + this.ingredient.toCommandString() + "' is unsupported"));
        } else {
            for (IItemStack it : iItemStacks) {
                ItemStack in = CraftTweakerMC.getItemStack((IItemStack)it);
                if (in.func_77973_b() instanceof ItemFood) {
                    itemFoods.add((ItemFood)in.func_77973_b());
                    continue;
                }
                CraftTweakerAPI.logWarning((String)("Item '" + it.toCommandString() + "' in ingredient '" + this.ingredient.toCommandString() + "' is not an ItemFood"));
            }
        }
        return itemFoods;
    }

    static CTFoodValues get(IIngredient i) {
        CTFoodValues in = MAP.get(i);
        if (in == null) {
            in = new CTFoodValues(i);
            MAP.put(i, in);
            LIST.add(in);
        }
        return in;
    }
}

