/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import java.util.Arrays;
import java.util.Random;

public class NoiseGeneratorBOPByte {
    private int numOctaves;
    private int octavesToSkip;
    private int[][] permutations;
    private int[] offsetU;
    private int[] offsetV;
    private int numX;
    private int numZ;
    private IIntInterpolater interpolater;
    public byte[][] noise;
    private static double[] doubleScalingsPerNumOctave = new double[]{96.0, 89.0, 83.0, 76.0, 72.0, 60.0, 48.0, 38.0, 30.0};
    private static final int[] rc2_a = new int[]{1, -1, 1, -1, 1, -1, 1, -1, 0, 0, 0, 0, 1, 0, -1, 0};
    private static final int[] rc2_b = new int[]{0, 0, 0, 0, 1, 1, -1, -1, 1, 1, -1, -1, 0, 1, 0, -1};

    public NoiseGeneratorBOPByte(Random rand, int numOctaves, int numX, int numZ) {
        if (numOctaves < 1) {
            throw new IllegalArgumentException("Must have at least one octave");
        }
        if (numOctaves > 8) {
            throw new IllegalArgumentException("Cannot have more than 8 octaves");
        }
        this.init(rand, numOctaves, numX, numZ, 0);
    }

    public NoiseGeneratorBOPByte(Random rand, int numOctaves, int numX, int numZ, int octavesToSkip) {
        if (numOctaves < 1) {
            throw new IllegalArgumentException("Must have at least one octave");
        }
        if (octavesToSkip < 0) {
            throw new IllegalArgumentException("octavesToSkip cannot be negative");
        }
        if (numOctaves + octavesToSkip > 8) {
            throw new IllegalArgumentException("sum of numOctaves and octavesToSkip cannot be more than 8");
        }
        this.init(rand, numOctaves, numX, numZ, octavesToSkip);
    }

    private void init(Random rand, int numOctaves, int numX, int numZ, int octavesToSkip) {
        this.numOctaves = numOctaves;
        this.octavesToSkip = octavesToSkip;
        this.numX = numX;
        this.numZ = numZ;
        this.interpolater = new IntInterpolateSmooth();
        this.permutations = new int[numOctaves][512];
        this.offsetU = new int[numOctaves];
        this.offsetV = new int[numOctaves];
        for (int i = 0; i < numOctaves; ++i) {
            this.generatePermutations(this.permutations[i], rand);
            this.offsetU[i] = rand.nextInt();
            this.offsetV[i] = rand.nextInt();
        }
    }

    public void setInterpolator(IIntInterpolater interpolator) {
        this.interpolater = interpolator;
    }

    public void generateNoise(int startX, int startZ) {
        this.noise = new byte[this.numOctaves][this.numX * this.numZ];
        for (int octave = 0; octave < this.numOctaves; ++octave) {
            this.populateNoise(octave, startX, startZ);
        }
    }

    public int getWeightedInt(int localX, int localZ, int[] weights) {
        return this.getWeightedInt(localX * this.numZ + localZ, weights);
    }

    public int getWeightedInt(int index, int[] weights) {
        int total = 0;
        for (int octave = 0; octave < this.numOctaves; ++octave) {
            total += weights[octave] * this.noise[octave][index];
        }
        return total;
    }

    public double getWeightedDouble(int localX, int localZ, double[] weights) {
        return this.getWeightedDouble(localX * this.numZ + localZ, weights);
    }

    public double getWeightedDouble(int index, double[] weights) {
        double total = 0.0;
        for (int octave = 0; octave < this.numOctaves; ++octave) {
            total += weights[octave] * (double)this.noise[octave][index];
        }
        return total / doubleScalingsPerNumOctave[this.numOctaves];
    }

    private void generatePermutations(int[] permutations, Random rand) {
        int i;
        for (i = 0; i < 256; ++i) {
            permutations[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int j = rand.nextInt(256 - i) + i;
            int k = permutations[i];
            permutations[i] = permutations[j];
            permutations[j] = k;
            permutations[i + 256] = permutations[i];
        }
    }

    public final int randomCombineTwo(int seed, int a, int b) {
        int j = seed & 0xF;
        return rc2_a[j] * a + rc2_b[j] * b;
    }

    private void populateNoise(int octave, int startX, int startZ) {
        int unitsUVperUnitXZ = 1 << 7 - octave - this.octavesToSkip;
        long startU = ((long)startX << 7 - octave - this.octavesToSkip) + (long)this.offsetU[octave];
        long startV = ((long)startZ << 7 - octave - this.octavesToSkip) + (long)this.offsetV[octave];
        int[] permutations = this.permutations[octave];
        byte[] noise = this.noise[octave];
        int index = 0;
        long u = startU;
        for (int localX = 0; localX < this.numX; ++localX) {
            int intU = (int)(u >> 8 & 0xFFL);
            int fracU = (int)(u & 0xFFL);
            int permU0 = permutations[intU];
            int permU1 = permutations[intU + 1];
            long v = startV;
            for (int localZ = 0; localZ < this.numZ; ++localZ) {
                int intV = (int)(v >> 8 & 0xFFL);
                int fracV = (int)(v & 0xFFL);
                int permV0 = permutations[permU0] + intV;
                int permV1 = permutations[permU1] + intV;
                int val00 = this.randomCombineTwo(permutations[permV0], fracU, fracV);
                int val01 = this.randomCombineTwo(permutations[permV1], fracU - 255, fracV);
                int val10 = this.randomCombineTwo(permutations[permV0 + 1], fracU, fracV - 255);
                int val11 = this.randomCombineTwo(permutations[permV1 + 1], fracU - 255, fracV - 255);
                int val0 = this.interpolater.interpolate(fracU, val00, val01);
                int val1 = this.interpolater.interpolate(fracU, val10, val11);
                int val = this.interpolater.interpolate(fracV, val0, val1);
                noise[index] = (val >>= 1) < 127 ? (val > -127 ? (int)val : -127) : 127;
                ++index;
                v += (long)unitsUVperUnitXZ;
            }
            u += (long)unitsUVperUnitXZ;
        }
    }

    public void getOctaveDistribution(int octave) {
        int[] counters = new int[64];
        int min = 256;
        int max = -256;
        for (byte b : this.noise[octave]) {
            int n = (b >> 2) + 32;
            counters[n] = counters[n] + 1;
            min = Math.min(min, b);
            max = Math.max(max, b);
        }
        int counterMax = 0;
        for (int i = 0; i < 64; ++i) {
            counterMax = Math.max(counterMax, counters[i]);
        }
        double scale = 50.0 / (double)counterMax;
        for (int i = 0; i < 64; ++i) {
            char[] line = new char[(int)((double)counters[i] * scale)];
            Arrays.fill(line, '+');
            int low = (i - 32) * 4;
            System.out.println(String.format("%-16s", low + " to " + (low + 3) + ":") + new String(line) + " " + counters[i]);
        }
        System.out.println("Min " + min + " Max " + max);
    }

    public void getWeightedDoubleDistribution(double[] weights) {
        int n = this.numX * this.numZ;
        double[] vals = new double[n];
        int bars = 32;
        int[] counters = new int[bars];
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            double val;
            vals[i] = val = this.getWeightedDouble(i, weights);
            max = Math.max(max, val);
            min = Math.min(min, val);
        }
        double interval = (max - min) / (double)bars;
        for (int j = 0; j < bars; ++j) {
            double barMin = min + interval * (double)j;
            double barMax = barMin + interval;
            for (int i = 0; i < n; ++i) {
                if (!(vals[i] > barMin) || !(vals[i] <= barMax)) continue;
                int n2 = j;
                counters[n2] = counters[n2] + 1;
            }
        }
        int countersMax = 0;
        for (int j = 0; j < bars; ++j) {
            countersMax = Math.max(countersMax, counters[j]);
        }
        double scale = 50.0 / (double)countersMax;
        for (int j = 0; j < bars; ++j) {
            double barMin = min + interval * (double)j;
            double barMax = barMin + interval;
            char[] line = new char[(int)((double)counters[j] * scale)];
            Arrays.fill(line, '+');
            System.out.println(String.format("%-50s", barMin + " to " + barMax + ":") + new String(line) + " " + counters[j]);
        }
    }

    public static void main(String[] args) {
        int numX = 1000;
        int numZ = 400;
        int numOctaves = 4;
        double[] weights = new double[numOctaves];
        for (int i = 0; i < numOctaves; ++i) {
            weights[i] = Math.pow(2.0, i) / (Math.pow(2.0, numOctaves) - 1.0);
        }
        NoiseGeneratorBOPByte noise = new NoiseGeneratorBOPByte(new Random(), numOctaves, numX, numZ);
        noise.generateNoise(4, 5);
        noise.getWeightedDoubleDistribution(weights);
    }

    public static class IntInterpolatePower
    implements IIntInterpolater {
        private int[] table = new int[256];

        public IntInterpolatePower(double power) {
            for (int i = 0; i < 256; ++i) {
                double t = (double)i / 256.0;
                this.table[i] = (int)Math.pow(t, power);
            }
        }

        @Override
        public int interpolate(int t, int a, int b) {
            return a + this.table[t] * (b - a) / 255;
        }
    }

    public static class IntInterpolateSmooth
    implements IIntInterpolater {
        private int[] table = new int[256];

        public IntInterpolateSmooth() {
            for (int i = 0; i < 256; ++i) {
                double t = (double)i / 256.0;
                this.table[i] = (int)(256.0 * t * t * t * (t * (t * 6.0 - 15.0) + 10.0));
            }
        }

        @Override
        public int interpolate(int t, int a, int b) {
            return a + this.table[t] * (b - a) / 255;
        }
    }

    public static class IntInterpolateLinear
    implements IIntInterpolater {
        @Override
        public int interpolate(int t, int a, int b) {
            return a + t * (b - a) / 255;
        }
    }

    public static interface IIntInterpolater {
        public int interpolate(int var1, int var2, int var3);
    }
}

