/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world;

import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.api.generation.IGenerationManager;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.world.GeneratorRegistry;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GenerationManager
implements IGenerationManager {
    private Map<String, IGenerator> generators = new HashMap<String, IGenerator>();

    @Override
    public void addGenerator(String name, GeneratorStage stage, IGenerator generator) {
        if (this.generators.containsKey(name)) {
            throw new RuntimeException("A generator with name " + name + " already exists!");
        }
        generator.setName(name);
        generator.setStage(stage);
        this.generators.put(name, generator);
    }

    @Override
    public ImmutableCollection<IGenerator> getGeneratorsForStage(GeneratorStage stage) {
        ArrayList<IGenerator> out = new ArrayList<IGenerator>();
        for (IGenerator generator : this.generators.values()) {
            if (generator.getStage() != stage) continue;
            out.add(generator);
        }
        return ImmutableList.copyOf(out);
    }

    @Override
    public void removeGenerator(String name) {
        this.generators.remove(name);
    }

    @Override
    public IGenerator getGenerator(String name) {
        return this.generators.get(name);
    }

    @Override
    public void configure(IConfigObj generatorsObj) {
        Iterator<String> genKeysItr = this.generators.keySet().iterator();
        while (genKeysItr.hasNext()) {
            String name = genKeysItr.next();
            IConfigObj currentObj = generatorsObj.getObject(name);
            if (currentObj.getBool("enable", true).booleanValue()) {
                this.generators.get(name).configure(currentObj);
                continue;
            }
            genKeysItr.remove();
        }
        for (String name : generatorsObj.getKeys()) {
            IConfigObj currentObj;
            IGenerator generator;
            if (!generatorsObj.has(name) || (generator = GeneratorRegistry.createGenerator(currentObj = generatorsObj.getObject(name))) == null) continue;
            this.generators.put(name, generator);
        }
    }
}

