/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import java.util.Collection;
import javax.annotation.Nullable;
import net.daveyx0.multimob.common.capabilities.CapabilityTameableEntity;
import net.daveyx0.multimob.common.capabilities.ITameableEntity;
import net.daveyx0.multimob.entity.IMultiMob;
import net.daveyx0.multimob.util.EntityUtil;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigSpecial;
import net.daveyx0.primitivemobs.core.PrimitiveMobsLootTables;
import net.daveyx0.primitivemobs.entity.monster.EntityPrimitiveCreeper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class EntityRocketCreeper
extends EntityPrimitiveCreeper
implements IMultiMob {
    private float explosionRadius = 3.0f;
    int timeBeforeJumping;
    private static final DataParameter<Boolean> IS_ROCKET = EntityDataManager.func_187226_a(EntityRocketCreeper.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityRocketCreeper(World worldIn) {
        super(worldIn);
        this.setRocket(false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperSwell((EntityCreeper)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.func_70090_H()) {
            this.func_70072_I();
        }
        if (onGroundIn) {
            if (this.field_70143_R > 0.0f) {
                state.func_177230_c().func_180658_a(this.field_70170_p, pos, (Entity)this, this.field_70143_R);
            }
            this.field_70143_R = 0.0f;
        } else if (y < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - y);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        if (this.isRocket()) {
            return;
        }
        super.func_180429_a(pos, blockIn);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_ROCKET, (Object)false);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.isRocket()) {
            this.explode();
        }
    }

    private void explode() {
        if (!this.func_130014_f_().field_72995_K) {
            boolean flag = this.func_130014_f_().func_82736_K().func_82766_b("mobGriefing");
            float f = this.func_70830_n() ? 2.0f : 1.0f;
            ITameableEntity tameable = (ITameableEntity)EntityUtil.getCapability((Entity)this, (Capability)CapabilityTameableEntity.TAMEABLE_ENTITY_CAPABILITY, null);
            if (tameable != null && tameable.isTamed()) {
                this.func_70097_a(DamageSource.field_76377_j, 1.0f);
                this.setRocket(false);
            } else {
                this.field_70729_aU = true;
                this.func_70106_y();
            }
            this.func_130014_f_().func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionRadius * f, flag);
            this.spawnLingeringCloud();
        }
    }

    public boolean hasEnoughSpaceToJump(Entity entityIn) {
        boolean flag = true;
        if (!PrimitiveMobsConfigSpecial.getRocketCreeperAlwaysJump()) {
            for (int i = 0; i < 5; ++i) {
                flag = this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + (double)i, this.field_70161_v), new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.func_70047_e(), entityIn.field_70161_v), false, true, false) == null;
            }
        }
        return flag;
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > 25.0) {
            this.setIgnitedTime(0);
            this.func_70829_a(-1);
        }
        this.timeBeforeJumping = this.func_70832_p() > 0 ? ++this.timeBeforeJumping : 0;
        if (this.timeBeforeJumping > 15 && this.func_70089_S() && this.func_70638_az() != null && this.hasEnoughSpaceToJump((Entity)this.func_70638_az())) {
            this.setIgnitedTime(0);
            int var1 = this.func_70832_p();
            if (var1 > 0 && this.field_70122_E) {
                if (this.func_130014_f_().field_72995_K) {
                    this.func_130014_f_().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u - (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) - 1.0, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
                }
                this.func_184185_a(SoundEvents.field_187631_bo, 1.0f, 0.5f);
                this.field_70181_x = 1.2f;
                this.field_70159_w = (this.func_70638_az().field_70165_t - this.field_70165_t) / 6.0;
                this.field_70179_y = (this.func_70638_az().field_70161_v - this.field_70161_v) / 6.0;
                this.setRocket(true);
            }
        }
        super.func_70071_h_();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrimitiveMobsLootTables.ENTITIES_ROCKETCREEPER;
    }

    public void setRocket(boolean rocket) {
        this.func_184212_Q().func_187227_b(IS_ROCKET, (Object)rocket);
    }

    public boolean isRocket() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ROCKET);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Rocket", this.isRocket());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRocket(compound.func_74767_n("Rocket"));
    }

    private void spawnLingeringCloud() {
        Collection collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.func_184483_a(2.5f);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() / 2);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            for (PotionEffect potioneffect : collection) {
                entityareaeffectcloud.func_184496_a(new PotionEffect(potioneffect));
            }
            this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (type == EnumCreatureType.MONSTER) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }
}

