/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.entity.monster;

import javax.annotation.Nullable;
import net.daveyx0.multimob.entity.IMultiMob;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigMobs;
import net.daveyx0.primitivemobs.config.PrimitiveMobsConfigSpecial;
import net.daveyx0.primitivemobs.core.PrimitiveMobsLootTables;
import net.daveyx0.primitivemobs.core.PrimitiveMobsSoundEvents;
import net.daveyx0.primitivemobs.entity.ai.EntityAIFollowerHurtByTarget;
import net.daveyx0.primitivemobs.entity.monster.EntityBabySpider;
import net.daveyx0.primitivemobs.entity.monster.EntityPrimitiveSpider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityMotherSpider
extends EntityPrimitiveSpider
implements IMultiMob {
    private final int minFollowers = 3;
    private final int maxFollowers = PrimitiveMobsConfigSpecial.getMaxSpiderFamilySize();
    private EntityLivingBase[] followers = new EntityLivingBase[this.maxFollowers];
    private static final DataParameter<Boolean> IS_ANGRY = EntityDataManager.func_187226_a(EntityMotherSpider.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityMotherSpider(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        if (!PrimitiveMobsConfigMobs.enableSpiderFamily) {
            this.func_70106_y();
        }
        this.func_184212_Q().func_187214_a(IS_ANGRY, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityPrimitiveSpider.AISpiderAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIFollowerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(3, new EntityPrimitiveSpider.AISpiderTarget<EntityPlayer>(this, EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, new EntityPrimitiveSpider.AISpiderTarget<EntityIronGolem>(this, EntityIronGolem.class));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_184188_bt().isEmpty()) {
            EntityBabySpider baby;
            if (this.func_184188_bt().get(0) instanceof EntityBabySpider && (baby = (EntityBabySpider)((Object)this.func_184188_bt().get(0))) != null) {
                baby.func_70661_as().func_75484_a(this.func_70661_as().func_75505_d(), 1.5);
                baby.func_70605_aq().func_188487_a(this.func_70605_aq());
            }
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.18);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        }
        if (this.isAngry()) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), this.field_70163_u + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public boolean func_70058_J() {
        return !this.field_70170_p.func_72953_d(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return PrimitiveMobsSoundEvents.ENTITY_MOTHERSPIDER_SCREECH;
    }

    public void addFollower(EntityLivingBase follower) {
        for (int i = 0; i < this.followers.length; ++i) {
            if (this.followers[i] != null) continue;
            this.followers[i] = follower;
            return;
        }
    }

    public EntityLivingBase[] getFollowers() {
        return this.followers;
    }

    public boolean hasFollowers() {
        if (this.getFollowers() == null) {
            return false;
        }
        for (int i = 0; i < this.followers.length; ++i) {
            if (this.followers[i] == null) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Potion potion;
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextGaussian() * 0.05, 1));
        if (livingdata == null) {
            livingdata = new EntityPrimitiveSpider.GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((EntityPrimitiveSpider.GroupData)livingdata).setRandomEffect(this.field_70170_p.field_73012_v);
            }
        }
        if (livingdata instanceof EntityPrimitiveSpider.GroupData && (potion = ((EntityPrimitiveSpider.GroupData)livingdata).effect) != null) {
            this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        for (int i = 0; i < this.maxFollowers; ++i) {
            if (this.func_130014_f_().field_72995_K || this.field_70146_Z.nextInt(2) != 0 && i > 3) continue;
            EntityBabySpider entityBabySpider = new EntityBabySpider(this.func_130014_f_());
            entityBabySpider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entityBabySpider.setTamed(true);
            entityBabySpider.setOwnerId(this.func_110124_au());
            this.func_130014_f_().func_72838_d((Entity)entityBabySpider);
            if (this.func_184207_aI()) continue;
            entityBabySpider.func_184220_m((Entity)this);
        }
        return livingdata;
    }

    public void setIsAngry(boolean begging) {
        this.func_184212_Q().func_187227_b(IS_ANGRY, (Object)begging);
    }

    public boolean isAngry() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_ANGRY);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Angry", this.isAngry());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setIsAngry(compound.func_74767_n("Angry"));
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f2 = 0.0f;
        if (passenger instanceof EntityBabySpider) {
            f2 = 0.25f;
        }
        passenger.func_70107_b(this.field_70165_t + (double)(0.1f * f), this.field_70163_u + (double)(this.field_70131_O * 0.5f + f2) + passenger.func_70033_W() + 0.0, this.field_70161_v - (double)(0.1f * f1));
        if (passenger instanceof EntityLivingBase) {
            ((EntityLivingBase)passenger).field_70761_aq = this.field_70761_aq;
        }
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return PrimitiveMobsLootTables.ENTITIES_MOTHERSPIDER;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (type == EnumCreatureType.MONSTER) {
            return false;
        }
        return super.isCreatureType(type, forSpawnCount);
    }
}

