/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.primitivemobs.client.models;

import net.daveyx0.primitivemobs.entity.monster.EntityFlameSpewer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.math.MathHelper;

public class ModelFlameSpewer
extends ModelBase {
    ModelRenderer body;
    ModelRenderer mouth;
    ModelRenderer[] tentacles = new ModelRenderer[8];
    float[] offset = new float[8];
    boolean renderTentacles;
    boolean isLava;

    public ModelFlameSpewer(int textureWidth, int textureHeight, boolean isLava, boolean renderTentacles) {
        this.field_78090_t = textureWidth;
        this.field_78089_u = textureHeight;
        this.renderTentacles = renderTentacles;
        this.isLava = isLava;
        this.body = new ModelRenderer((ModelBase)this, 0, 0);
        this.body.func_78789_a(-7.0f, -16.0f, -7.0f, 14, 16, 14);
        this.body.func_78793_a(0.0f, 21.0f, 0.0f);
        this.body.func_78787_b(32, 512);
        this.body.field_78809_i = true;
        this.setRotation(this.body, 0.0f, 0.0f, 0.0f);
        this.mouth = this.isLava ? new ModelRenderer((ModelBase)this, 16, 0) : new ModelRenderer((ModelBase)this, 43, 0);
        this.mouth.func_78789_a(-2.0f, -5.0f, -10.0f, 4, 4, 4);
        this.mouth.func_78793_a(0.0f, 21.0f, 0.0f);
        this.mouth.func_78787_b(32, 512);
        this.mouth.field_78809_i = true;
        this.setRotation(this.mouth, 0.1570796f, 0.0f, 0.0f);
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i] = this.isLava ? new ModelRenderer((ModelBase)this, 0, 16) : new ModelRenderer((ModelBase)this, 0, 30);
            this.tentacles[i].func_78789_a(-2.0f, 0.0f, -26.0f, 4, 4, 24);
            this.tentacles[i].func_78793_a(0.0f, 18.0f, 0.0f);
            this.tentacles[i].func_78787_b(32, 512);
            this.tentacles[i].field_78809_i = true;
            this.setRotation(this.tentacles[i], 0.4537856f, (float)Math.toRadians(22.5 + (double)(45 * i)), 0.0f);
            this.offset[i] = 0.0f;
        }
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        super.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        EntityFlameSpewer spewer = (EntityFlameSpewer)entityIn;
        GlStateManager.func_179094_E();
        float f = 1.0f + spewer.getAttackSignal();
        GlStateManager.func_179137_b((double)0.0, (double)((double)(-f) + 0.9), (double)0.0);
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
        this.body.func_78785_a(scale);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        float e = MathHelper.func_76126_a((float)((float)entityIn.field_70173_aa * 0.5f)) * 0.03f + 1.0f;
        GlStateManager.func_179137_b((double)0.0, (double)-0.1, (double)0.0);
        GlStateManager.func_179152_a((float)e, (float)e, (float)e);
        this.mouth.func_78785_a(scale);
        GlStateManager.func_179121_F();
        if (this.renderTentacles) {
            for (int i = 0; i < this.tentacles.length; ++i) {
                this.tentacles[i].func_78785_a(scale);
            }
        }
        Item mob = Items.field_185153_aK;
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        EntityFlameSpewer spewer = (EntityFlameSpewer)entityIn;
        this.mouth.field_78796_g = this.body.field_78796_g = netHeadYaw / 57.295776f;
        if (!this.isLava) {
            for (int i = 0; i < this.tentacles.length; ++i) {
                if (this.offset[i] == 0.0f) {
                    this.offset[i] = spewer.func_70681_au().nextFloat() - spewer.func_70681_au().nextFloat() + 0.01f;
                }
                if (spewer.isInDanger()) {
                    ModelFlameSpewer.idleTentacle(this.tentacles[i], (float)spewer.field_70173_aa * 0.75f + this.offset[i], 10.0f);
                    continue;
                }
                ModelFlameSpewer.idleTentacle(this.tentacles[i], (float)spewer.field_70173_aa * 0.15f + this.offset[i], 4.0f);
            }
        }
    }

    public static void idleTentacle(ModelRenderer model, float e, float f) {
        model.field_78795_f = MathHelper.func_76126_a((float)e) * f * ((float)Math.PI / 180);
    }

    public void setFlameSpewerModelAttributes(ModelFlameSpewer model) {
        for (int i = 0; i < this.tentacles.length; ++i) {
            this.tentacles[i].field_78795_f = model.tentacles[i].field_78795_f;
        }
        super.func_178686_a((ModelBase)model);
    }
}

