/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items.books;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.DungeonTactics;
import pegbeard.dungeontactics.handlers.DTConfigHandler;
import pegbeard.dungeontactics.handlers.DTCreativeTab;

public class DTDungeonpediaBook2
extends ItemWrittenBook {
    public DTDungeonpediaBook2(String name) {
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(DTCreativeTab.DT_TAB);
        ItemStack book = new ItemStack(Items.field_151099_bA);
        this.populatePages(book);
    }

    private void populatePages(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77982_d(tag);
        NBTTagList bookPages = new NBTTagList();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("pages")) {
            stack.func_190919_e("pages");
        }
        tag.func_74782_a("pages", (NBTBase)bookPages);
        if (DTConfigHandler.configuration.get("1-Feature", "Seasonal Events", true).getBoolean(true) && DungeonTactics.fools) {
            tag.func_74778_a("author", "\u00ef\u00bf\u00bdkMoomin");
            tag.func_74778_a("title", "Super Useful Guidebook");
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Book of All\n\n\u00ef\u00bf\u00bdl     Knowledge\n\n\u00ef\u00bf\u00bdl     Volume \u00ef\u00bf\u00bdk999\""));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThis immense collection of books contains all knowledge of life, there-after, and the universe.\""));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdkIf you can read this, you are cheating ;) Happy April Fools Day abcd efg hijk lmnop qrs tuv wxy and z 42\u00ef\u00bf\u00bdr.....\n\n*The ink has run and the words are completely illegible.*\""));
            return;
        }
        tag.func_74778_a("author", "Some probably-dead guy");
        tag.func_74778_a("title", "Weapons");
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl   Dungeonpedia\n\n\u00ef\u00bf\u00bdl     Volume 2\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThis volume contains information on different weapons and their uses.\n\nSection 1 contains melee weapons.\nSection 2 contains imbuements.\nSection 3 contains ranged weapons.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Section 1\n\n\u00ef\u00bf\u00bdl   Melee Combat\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl   Mastery Weapons\n\nMastery Weapons allow the wielder to use special abilities.\nTo activate this ability, you must use your held weapon - most abilities cannot be used while holding a shield.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Swords\n\nSwords and Cutlasses are the mid-ground weapon. Aveverage in both speed and offence.\n\nThe ability \u00ef\u00bf\u00bdlRiposte\u00ef\u00bf\u00bdr allows the wielder to block and counter an incoming attack, when timed properly.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThe ability \u00ef\u00bf\u00bdlPierce\u00ef\u00bf\u00bdr allows the wielder to ignore a portion of the targets armour.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Hammers\n\nHammers hit hard, but have a slower attack speed than swords.\n\nThe \u00ef\u00bf\u00bdlLeaping\u00ef\u00bf\u00bdr ability allows the wielder to propel themselves forward into, or out of, battle.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThe \u00ef\u00bf\u00bdlSmash\u00ef\u00bf\u00bdr ability creates an explosive force around the wielder, knocking back and damaging all foes.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    Battleaxes\n\nBattleaxes are like sharp hammers, still slow, but with a bit more damage.\nThough this weapon type cannot be mastered, it has a good chance to decapitate foes.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Glaives\n\nGlaives are the pointiest of pointy sticks, perfect for poking things at range.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Knives\n\nKnives are built for speed, but lack the damage and reach of larger blades.\n\nThe \u00ef\u00bf\u00bdlSmokeBomb\u00ef\u00bf\u00bdr ability allows the wielder to disappear briefly, to escape, or gain an advantage over a foe.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThe \u00ef\u00bf\u00bdlMultistrike\u00ef\u00bf\u00bdr ability allows the wielder to dash to multiple targets and strike them all at once.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Cestus\n\nA true berserker's weapon, this weapon can be swung as fast as you can punch, but only as far as you can reach.\n\nThe \u00ef\u00bf\u00bdlRoar\u00ef\u00bf\u00bdr ability unleashes a primal rage, bolstering strength, knocking back and stunning groups of attackers.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThe \u00ef\u00bf\u00bdlPummel\u00ef\u00bf\u00bdr ability allows the wielder to unleash a flurry of blows, dealing multiple strikes to a single target.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Shields\n\nA portable wall, perfect for protecting your pretty little face from the ravages of combat. Also doubles as a tool to bash your foes away.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Section 2\n\n\u00ef\u00bf\u00bdl      Imbuing\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nOther gateways to ultimate power are available.\nJust light a fire below the cauldron, throw a flower in and stir with your weapon of choice.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nCoating your weapon in poison is a quick and easy way to gain an advantage in combat, though it is temporary. Mix and match poisons for best results. Warrenty not included.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\nThe combat orientated definitely want to keep an eye out for weapon enchantments, such as '\u00ef\u00bf\u00bdlBerserking\u00ef\u00bf\u00bdr' which increases the weilder's damage the less armour the have, '\u00ef\u00bf\u00bdlRuned\u00ef\u00bf\u00bdr' which converts some physical damage dealt to magical damage.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n'\u00ef\u00bf\u00bdlLife Steal\u00ef\u00bf\u00bdr' which heals the wielder for a portion of the damage they deal, and \u00ef\u00bf\u00bdlSYNTAX ERROR\u00ef\u00bf\u00bdr: Token not found (jk, I just didn't add it yet).\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl    NotYetImplemented\n    MysteryShenanigans\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\n\u00ef\u00bf\u00bdl     Section 3\n\n\u00ef\u00bf\u00bdl  Ranged Combat\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Slingshot\n\nThe Slingshot is easy to make and easy to use. Allowing for a reasonable rate of fire but less damage than a bow.\nSlingshots are capable of firing seeds, flint, and cherrybombs, each having a different effect on the target.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl      Potshot\n\nMechanically propelled ordinance at it's finest. The Potshot always fires at full power with decent impact damage.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"The versatile projectile morphs to the weapons enchantments, such as the '\u00ef\u00bf\u00bdlExploding\u00ef\u00bf\u00bdr', '\u00ef\u00bf\u00bdlBonus Package\u00ef\u00bf\u00bdr', or '\u00ef\u00bf\u00bdlDebilitating\u00ef\u00bf\u00bdr' enchantments, causing anything from explosive damage, fragmenting projectiles, or caustic slime damage respectively.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\u00ef\u00bf\u00bdl        Bombs\n\nLight the fuse and throw or launch from a dispenser, bombs are excellent for crowd control. Letting the fuse burn for a bit, before throwing, will reduce the time the grenade takes to explode, but don't hold it too long.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"Adding certain ingredients to the mix imbues the bomb with one of several effects.\n\n\u00ef\u00bf\u00bdlBasic bombs\u00ef\u00bf\u00bdr explode, dealing damage to targets.\n\n\u00ef\u00bf\u00bdlPyro bombs\u00ef\u00bf\u00bdr explode with fire, dealing slightly less immediate damage.\""));
        bookPages.func_74742_a((NBTBase)new NBTTagString("\"\n\u00ef\u00bf\u00bdlPorting bombs\u00ef\u00bf\u00bdr deal very low damage and teleport all targets away.\n\n\u00ef\u00bf\u00bdlCryo bombs\u00ef\u00bf\u00bdr cause low damage and temporarily freeze targets. Frozen enemies take increased damage.\""));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77978_p() == null) {
            this.populatePages(itemstack);
        }
        if (!world.field_72995_K) {
            this.resolveContents(itemstack, player);
        }
        if (world.field_72995_K) {
            DungeonTactics.INSTANCE.openDungeonBook(player, itemstack, false);
        }
        player.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public static boolean validBookTagContents(NBTTagCompound nbt) {
        if (!ItemWritableBook.func_150930_a((NBTTagCompound)nbt)) {
            return false;
        }
        if (!nbt.func_150297_b("title", 8)) {
            return false;
        }
        String s = nbt.func_74779_i("title");
        return s != null && s.length() <= 32 ? nbt.func_150297_b("author", 8) : false;
    }

    public static int getGeneration(ItemStack book) {
        return book.func_77978_p().func_74762_e("generation");
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbttagcompound;
        String s;
        if (stack.func_77942_o() && !StringUtils.func_151246_b((String)(s = (nbttagcompound = stack.func_77978_p()).func_74779_i("title")))) {
            return s;
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbttagcompound = stack.func_77978_p();
            String s = nbttagcompound.func_74779_i("author");
            if (!StringUtils.func_151246_b((String)s)) {
                tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"book.byAuthor", (Object[])new Object[]{s}));
            }
            tooltip.add(TextFormatting.GRAY + I18n.func_74838_a((String)("book.generation." + nbttagcompound.func_74762_e("generation"))));
        }
    }

    private void resolveContents(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbttagcompound;
        if (stack.func_77978_p() != null && !(nbttagcompound = stack.func_77978_p()).func_74767_n("resolved")) {
            nbttagcompound.func_74757_a("resolved", true);
            if (DTDungeonpediaBook2.validBookTagContents(nbttagcompound)) {
                NBTTagList nbttaglist = nbttagcompound.func_150295_c("pages", 8);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    ITextComponent itextcomponent;
                    String s = nbttaglist.func_150307_f(i);
                    try {
                        itextcomponent = ITextComponent.Serializer.func_186877_b((String)s);
                        itextcomponent = TextComponentUtils.func_179985_a((ICommandSender)player, (ITextComponent)itextcomponent, (Entity)player);
                    }
                    catch (Exception var9) {
                        itextcomponent = new TextComponentString(s);
                    }
                    nbttaglist.func_150304_a(i, (NBTBase)new NBTTagString(ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent)));
                }
                nbttagcompound.func_74782_a("pages", (NBTBase)nbttaglist);
                if (player instanceof EntityPlayerMP && player.func_184614_ca() == stack) {
                    Slot slot = player.field_71070_bA.func_75147_a((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c);
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(0, slot.field_75222_d, stack));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

