/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thermalexpansion.dynamos;

import cofh.thermalexpansion.util.managers.dynamo.ReactantManager;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.ReactantDynamo")
@ModOnly(value="thermalexpansion")
@ZenRegister
public class ReactantDynamo {
    @ZenMethod
    public static void addReaction(IItemStack stack, ILiquidStack fluid, int energy) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)stack), InputHelper.toFluid((ILiquidStack)fluid).getFluid(), energy));
    }

    @ZenMethod
    public static void addReactionElemental(IItemStack stack, ILiquidStack fluid, int energy) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddElemental(InputHelper.toStack((IItemStack)stack), InputHelper.toFluid((ILiquidStack)fluid).getFluid(), energy));
    }

    @ZenMethod
    public static void removeReaction(IItemStack stack, ILiquidStack fluid) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStack((IItemStack)stack), InputHelper.toFluid((ILiquidStack)fluid).getFluid()));
    }

    @ZenMethod
    public static void removeReactionElemental(IItemStack stack, ILiquidStack fluid) {
        ModTweaker.LATE_REMOVALS.add((IAction)new RemoveElemental(InputHelper.toStack((IItemStack)stack), InputHelper.toFluid((ILiquidStack)fluid).getFluid()));
    }

    private static class RemoveElemental
    extends BaseAction {
        private ItemStack stack;
        private Fluid fluid;

        protected RemoveElemental(ItemStack stack, Fluid fluid) {
            super("ReactantDynamo");
            this.stack = stack;
            this.fluid = fluid;
        }

        public void apply() {
            ReactantManager.removeElementalReaction((ItemStack)this.stack, (Fluid)this.fluid);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.stack) + " " + LogHelper.getStackDescription((Object)this.fluid);
        }
    }

    private static class AddElemental
    extends BaseAction {
        private ItemStack stack;
        private Fluid fluid;
        private int energy;

        protected AddElemental(ItemStack stack, Fluid fluid, int energy) {
            super("ReactantDynamoElemental");
            this.stack = stack;
            this.fluid = fluid;
            this.energy = energy;
        }

        public void apply() {
            ReactantManager.addElementalReaction((ItemStack)this.stack, (Fluid)this.fluid, (int)this.energy);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.stack) + " " + LogHelper.getStackDescription((Object)this.fluid);
        }
    }

    private static class Remove
    extends BaseAction {
        private ItemStack stack;
        private Fluid fluid;

        protected Remove(ItemStack stack, Fluid fluid) {
            super("ReactantDynamo");
            this.stack = stack;
            this.fluid = fluid;
        }

        public void apply() {
            ReactantManager.removeReaction((ItemStack)this.stack, (Fluid)this.fluid);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.stack) + " " + LogHelper.getStackDescription((Object)this.fluid);
        }
    }

    private static class Add
    extends BaseAction {
        private ItemStack stack;
        private Fluid fluid;
        private int energy;

        protected Add(ItemStack stack, Fluid fluid, int energy) {
            super("ReactantDynamo");
            this.stack = stack;
            this.fluid = fluid;
            this.energy = energy;
        }

        public void apply() {
            ReactantManager.addReaction((ItemStack)this.stack, (Fluid)this.fluid, (int)this.energy);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.stack) + " " + LogHelper.getStackDescription((Object)this.fluid);
        }
    }
}

