/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tcomplement.highoven;

import com.blamejared.ModTweaker;
import com.blamejared.compat.mantle.RecipeMatchIIngredient;
import com.blamejared.compat.tcomplement.highoven.recipes.MixRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import com.google.common.collect.ImmutableList;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.steelworks.IMixRecipe;
import knightminer.tcomplement.library.steelworks.MixAdditive;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="mods.tcomplement.highoven.MixRecipeBuilder")
@ZenRegister
@ModOnly(value="tcomplement")
public class MixRecipeBuilder {
    private ILiquidStack output;
    private ILiquidStack input;
    private int temp;
    private Map<IIngredient, Integer> oxidizers;
    private Map<IIngredient, Integer> reducers;
    private Map<IIngredient, Integer> purifiers;

    public MixRecipeBuilder(ILiquidStack output, ILiquidStack input, int temp) {
        this.output = output;
        this.input = input;
        this.temp = temp;
        this.oxidizers = new LinkedHashMap<IIngredient, Integer>();
        this.reducers = new LinkedHashMap<IIngredient, Integer>();
        this.purifiers = new LinkedHashMap<IIngredient, Integer>();
    }

    @ZenGetter(value="output")
    public ILiquidStack getOutput() {
        return this.output;
    }

    @ZenSetter(value="output")
    public void setOutput(ILiquidStack output) {
        this.output = output;
    }

    @ZenGetter(value="input")
    public ILiquidStack getInput() {
        return this.input;
    }

    @ZenSetter(value="input")
    public void setInput(ILiquidStack input) {
        this.input = input;
    }

    @ZenGetter(value="temp")
    public int getTemp() {
        return this.temp;
    }

    @ZenSetter(value="temp")
    public void setTemp(int temp) {
        this.temp = temp;
    }

    @ZenGetter(value="oxidizers")
    public List<IIngredient> getOxidizers() {
        return ImmutableList.copyOf(this.oxidizers.keySet());
    }

    @ZenGetter(value="reducers")
    public List<IIngredient> getReducers() {
        return ImmutableList.copyOf(this.reducers.keySet());
    }

    @ZenGetter(value="purifiers")
    public List<IIngredient> getPurifiers() {
        return ImmutableList.copyOf(this.purifiers.keySet());
    }

    @ZenMethod
    public int getOxidizerChance(IIngredient oxidizer) {
        return this.oxidizers.getOrDefault(oxidizer, -1);
    }

    @ZenMethod
    public int getReducerChance(IIngredient reducer) {
        return this.reducers.getOrDefault(reducer, -1);
    }

    @ZenMethod
    public int getPurifierChance(IIngredient purifier) {
        return this.purifiers.getOrDefault(purifier, -1);
    }

    @ZenMethod
    public MixRecipeBuilder addOxidizer(IIngredient oxidizer, int consumeChance) {
        this.oxidizers.put(oxidizer, consumeChance);
        return this;
    }

    @ZenMethod
    public MixRecipeBuilder addReducer(IIngredient reducer, int consumeChance) {
        this.reducers.put(reducer, consumeChance);
        return this;
    }

    @ZenMethod
    public MixRecipeBuilder addPurifier(IIngredient purifier, int consumeChance) {
        this.purifiers.put(purifier, consumeChance);
        return this;
    }

    @ZenMethod
    public MixRecipeBuilder removeOxidizer(IIngredient oxidizer) {
        this.oxidizers.remove(oxidizer);
        return this;
    }

    @ZenMethod
    public MixRecipeBuilder removeReducer(IIngredient reducer) {
        this.reducers.remove(reducer);
        return this;
    }

    @ZenMethod
    public MixRecipeBuilder removePurifier(IIngredient purifier) {
        this.purifiers.remove(purifier);
        return this;
    }

    @ZenMethod
    public MixRecipeBuilder removeAllOxidizer() {
        this.oxidizers = new LinkedHashMap<IIngredient, Integer>();
        return this;
    }

    @ZenMethod
    public MixRecipeBuilder removeAllReducer() {
        this.reducers = new LinkedHashMap<IIngredient, Integer>();
        return this;
    }

    @ZenMethod
    public MixRecipeBuilder removeAllPurifier() {
        this.purifiers = new LinkedHashMap<IIngredient, Integer>();
        return this;
    }

    @ZenMethod
    public void register() {
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddMixRecipe(this.output, this.input, this.temp, this.oxidizers, this.reducers, this.purifiers));
    }

    private static class AddMixRecipe
    extends BaseAction {
        private FluidStack input;
        private FluidStack output;
        private int temp;
        private List<AbstractMap.SimpleEntry<RecipeMatch, MixAdditive>> additives;

        public AddMixRecipe(ILiquidStack output, ILiquidStack input, int temp, Map<IIngredient, Integer> oxidizers, Map<IIngredient, Integer> reducers, Map<IIngredient, Integer> purifiers) {
            super("High Oven Mix");
            this.input = InputHelper.toFluid((ILiquidStack)input);
            this.output = InputHelper.toFluid((ILiquidStack)output);
            this.temp = temp;
            this.additives = new LinkedList<AbstractMap.SimpleEntry<RecipeMatch, MixAdditive>>();
            oxidizers.forEach((ingredient, chance) -> this.additives.add(new AbstractMap.SimpleEntry<RecipeMatchIIngredient, MixAdditive>(new RecipeMatchIIngredient((IIngredient)ingredient, (int)chance), MixAdditive.OXIDIZER)));
            reducers.forEach((ingredient, chance) -> this.additives.add(new AbstractMap.SimpleEntry<RecipeMatchIIngredient, MixAdditive>(new RecipeMatchIIngredient((IIngredient)ingredient, (int)chance), MixAdditive.REDUCER)));
            purifiers.forEach((ingredient, chance) -> this.additives.add(new AbstractMap.SimpleEntry<RecipeMatchIIngredient, MixAdditive>(new RecipeMatchIIngredient((IIngredient)ingredient, (int)chance), MixAdditive.PURIFIER)));
        }

        public void apply() {
            IMixRecipe recipe = TCompRegistry.registerMix((IMixRecipe)new MixRecipeTweaker(this.input, this.output, this.temp));
            for (AbstractMap.SimpleEntry<RecipeMatch, MixAdditive> entry : this.additives) {
                recipe.addAdditive(entry.getValue(), entry.getKey());
            }
        }

        public String describe() {
            return String.format("Adding %s Recipe for %s", this.name, this.getRecipeInfo());
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output) + " from " + LogHelper.getStackDescription((FluidStack)this.input);
        }
    }
}

