/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.tcomplement.highoven;

import com.blamejared.ModTweaker;
import com.blamejared.compat.mantle.RecipeMatchIIngredient;
import com.blamejared.compat.tcomplement.highoven.MixRecipeBuilder;
import com.blamejared.compat.tcomplement.highoven.MixRecipeManager;
import com.blamejared.compat.tcomplement.highoven.recipes.HeatRecipeTweaker;
import com.blamejared.compat.tcomplement.highoven.recipes.HighOvenFuelTweaker;
import com.blamejared.compat.tcomplement.highoven.recipes.MixRecipeTweaker;
import com.blamejared.compat.tconstruct.recipes.MeltingRecipeTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.mc1120.item.MCItemStack;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import knightminer.tcomplement.library.TCompRegistry;
import knightminer.tcomplement.library.events.TCompRegisterEvent;
import knightminer.tcomplement.library.steelworks.HighOvenFuel;
import knightminer.tcomplement.library.steelworks.IHeatRecipe;
import knightminer.tcomplement.library.steelworks.IMixRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.util.Pair;

@ZenClass(value="mods.tcomplement.highoven.HighOven")
@ZenRegister
@ModOnly(value="tcomplement")
public class HighOven {
    public static final List<IIngredient> REMOVED_FUELS = new LinkedList<IIngredient>();
    public static final Map<ILiquidStack, IItemStack> REMOVED_OVERRIDES = new LinkedHashMap<ILiquidStack, IItemStack>();
    public static final List<Pair<FluidStack, FluidStack>> REMOVED_HEAT_RECIPES = new LinkedList<Pair<FluidStack, FluidStack>>();
    public static final List<Pair<FluidStack, FluidStack>> REMOVED_MIX_RECIPES = new LinkedList<Pair<FluidStack, FluidStack>>();
    private static boolean init = false;

    private static void init() {
        if (!init) {
            MinecraftForge.EVENT_BUS.register((Object)new HighOven());
            init = true;
        }
    }

    @ZenMethod
    public static void removeFuel(IIngredient stack) {
        HighOven.init();
        CraftTweakerAPI.apply((IAction)new RemoveFuel(stack));
    }

    @ZenMethod
    public static void addFuel(IIngredient fuel, int burnTime, int tempRate) {
        HighOven.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddFuel(fuel, burnTime, tempRate));
    }

    @ZenMethod
    public static void addMeltingOverride(ILiquidStack output, IIngredient input, @Optional int temp) {
        HighOven.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddMelting(InputHelper.toFluid((ILiquidStack)output), input, temp == 0 ? -1 : temp));
    }

    @ZenMethod
    public static void removeMeltingOverride(ILiquidStack output, @Optional IItemStack input) {
        HighOven.init();
        CraftTweakerAPI.apply((IAction)new RemoveMelting(output, input));
    }

    @ZenMethod
    public static void removeHeatRecipe(ILiquidStack output, @Optional ILiquidStack input) {
        HighOven.init();
        CraftTweakerAPI.apply((IAction)new RemoveHeat(input, output));
    }

    @ZenMethod
    public static void addHeatRecipe(ILiquidStack output, ILiquidStack input, int temp) {
        HighOven.init();
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddHeat(InputHelper.toFluid((ILiquidStack)output), InputHelper.toFluid((ILiquidStack)input), temp));
    }

    @ZenMethod
    public static void removeMixRecipe(ILiquidStack output, @Optional ILiquidStack input) {
        HighOven.init();
        CraftTweakerAPI.apply((IAction)new RemoveMix(output, input));
    }

    @ZenMethod
    public static MixRecipeBuilder newMixRecipe(ILiquidStack output, ILiquidStack input, int temp) {
        HighOven.init();
        return new MixRecipeBuilder(output, input, temp);
    }

    @ZenMethod
    public static MixRecipeManager manageMixRecipe(ILiquidStack output, ILiquidStack input) {
        HighOven.init();
        return new MixRecipeManager(output, input);
    }

    @SubscribeEvent
    public void onHighOvenFuelRegister(TCompRegisterEvent.HighOvenFuelRegisterEvent event) {
        if (event.getRecipe() instanceof HighOvenFuelTweaker) {
            return;
        }
        for (IIngredient entry : REMOVED_FUELS) {
            for (ItemStack fuel : ((HighOvenFuel)event.getRecipe()).getFuels()) {
                if (!entry.matches((IItemStack)new MCItemStack(fuel))) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onHighOvenHeatRegister(TCompRegisterEvent.HighOvenHeatRegisterEvent event) {
        if (event.getRecipe() instanceof HeatRecipeTweaker) {
            return;
        }
        for (Pair<FluidStack, FluidStack> entry : REMOVED_HEAT_RECIPES) {
            if (!((IHeatRecipe)event.getRecipe()).matches((FluidStack)entry.getKey(), (FluidStack)entry.getValue())) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onHighOvenMixRegister(TCompRegisterEvent.HighOvenMixRegisterEvent event) {
        if (event.getRecipe() instanceof MixRecipeTweaker) {
            return;
        }
        for (Pair<FluidStack, FluidStack> entry : REMOVED_MIX_RECIPES) {
            if (!((IMixRecipe)event.getRecipe()).matches((FluidStack)entry.getKey(), (FluidStack)entry.getValue())) continue;
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onHighOvenOverrideRegister(TCompRegisterEvent.HighOvenOverrideRegisterEvent event) {
        if (event.getRecipe() instanceof MeltingRecipeTweaker) {
            return;
        }
        for (Map.Entry<ILiquidStack, IItemStack> entry : REMOVED_OVERRIDES.entrySet()) {
            if (!((MeltingRecipe)event.getRecipe()).getResult().isFluidEqual((FluidStack)entry.getKey().getInternal())) continue;
            if (entry.getValue() != null) {
                if (!((MeltingRecipe)event.getRecipe()).input.matches(NonNullList.func_191197_a((int)1, (Object)((ItemStack)entry.getValue().getInternal()))).isPresent()) continue;
                event.setCanceled(true);
                continue;
            }
            event.setCanceled(true);
        }
    }

    private static class RemoveMix
    extends BaseAction {
        private ILiquidStack output;
        private ILiquidStack input;

        public RemoveMix(ILiquidStack output, ILiquidStack input) {
            super("High Oven Mix");
            this.output = output;
            this.input = input;
        }

        public void apply() {
            REMOVED_MIX_RECIPES.add((Pair<FluidStack, FluidStack>)new Pair((Object)InputHelper.toFluid((ILiquidStack)this.input), (Object)InputHelper.toFluid((ILiquidStack)this.output)));
        }

        public String describe() {
            return String.format("Removing %s Recipe(s) for %s", this.name, this.getRecipeInfo());
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output) + (this.input == null ? "" : " from " + LogHelper.getStackDescription((IIngredient)this.input));
        }
    }

    private static class RemoveHeat
    extends BaseAction {
        private ILiquidStack input;
        private ILiquidStack output;

        public RemoveHeat(ILiquidStack input, ILiquidStack output) {
            super("High Oven Heat");
            this.input = input;
            this.output = output;
        }

        public void apply() {
            REMOVED_HEAT_RECIPES.add((Pair<FluidStack, FluidStack>)new Pair((Object)InputHelper.toFluid((ILiquidStack)this.input), (Object)InputHelper.toFluid((ILiquidStack)this.output)));
        }

        public String describe() {
            return String.format("Removing %s Recipe(s) for %s", this.name, this.getRecipeInfo());
        }

        public String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output) + (this.input == null ? "" : " from " + LogHelper.getStackDescription((IIngredient)this.input));
        }
    }

    private static class AddHeat
    extends BaseAction {
        private FluidStack output;
        private FluidStack input;
        private int temp;

        public AddHeat(FluidStack output, FluidStack input, int temp) {
            super("High Oven Heat");
            this.output = output;
            this.input = input;
            this.temp = temp;
        }

        public void apply() {
            TCompRegistry.registerHeatRecipe((IHeatRecipe)new HeatRecipeTweaker(this.input, this.output, this.temp));
        }

        public String describe() {
            return String.format("Adding %s Recipe for %s", this.name, this.getRecipeInfo());
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }

    private static class RemoveMelting
    extends BaseAction {
        private ILiquidStack output;
        private IItemStack input;

        public RemoveMelting(ILiquidStack output, IItemStack input) {
            super("High Oven melting override");
            this.input = input;
            this.output = output;
        }

        public void apply() {
            REMOVED_OVERRIDES.put(this.output, this.input);
        }

        public String describe() {
            return String.format("Removing %s Recipe(s) for %s", this.name, this.getRecipeInfo());
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.output);
        }
    }

    private static class AddMelting
    extends BaseAction {
        private IIngredient input;
        private FluidStack output;
        private int temp;

        public AddMelting(FluidStack output, IIngredient input, int temp) {
            super("High Oven melting override");
            this.input = input;
            this.output = output;
            this.temp = temp;
        }

        public void apply() {
            if (this.temp > 0) {
                TCompRegistry.registerHighOvenOverride((MeltingRecipe)new MeltingRecipeTweaker((RecipeMatch)new RecipeMatchIIngredient(this.input, this.output.amount), this.output, this.temp));
            } else {
                TCompRegistry.registerHighOvenOverride((MeltingRecipe)new MeltingRecipeTweaker((RecipeMatch)new RecipeMatchIIngredient(this.input, this.output.amount), this.output));
            }
        }

        public String describe() {
            return String.format("Adding %s for %s", this.name, this.getRecipeInfo());
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.input) + ", now yields " + LogHelper.getStackDescription((FluidStack)this.output);
        }
    }

    private static class RemoveFuel
    extends BaseAction {
        private IIngredient fuel;

        public RemoveFuel(IIngredient fuel) {
            super("High Oven fuel");
            this.fuel = fuel;
        }

        public void apply() {
            REMOVED_FUELS.add(this.fuel);
        }

        public String describe() {
            return String.format("Removing %s as %s", this.getRecipeInfo(), this.name);
        }

        public String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.fuel);
        }
    }

    private static class AddFuel
    extends BaseAction {
        private IIngredient fuel;
        private int time;
        private int rate;

        public AddFuel(IIngredient fuel, int time, int rate) {
            super("High Oven fuel");
            this.fuel = fuel;
            this.time = time;
            this.rate = rate;
        }

        public void apply() {
            TCompRegistry.registerFuel((HighOvenFuel)new HighOvenFuelTweaker(new RecipeMatchIIngredient(this.fuel), this.time, this.rate));
        }

        public String describe() {
            return String.format("Adding %s as %s", this.getRecipeInfo(), this.name);
        }

        public String getRecipeInfo() {
            return LogHelper.getStackDescription((IIngredient)this.fuel);
        }
    }
}

