/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.immersivetech;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidStack;
import ferro2000.immersivetech.api.energy.SteamHandler;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersivetech.SteamTurbine")
@ZenRegister
@ModOnly(value="immersivetech")
public class SteamTurbine {
    @ZenMethod
    public static void registerSteam(ILiquidStack input, int burnTime) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toFluid((ILiquidStack)input), burnTime));
    }

    @ZenMethod
    public static void removeSteam(ILiquidStack input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toFluid((ILiquidStack)input)));
    }

    private static class Remove
    extends BaseAction {
        private FluidStack input;

        public Remove(FluidStack input) {
            super("SteamTurbine");
            this.input = input;
        }

        public void apply() {
            SteamHandler.getSteamValues().remove(this.input.getFluid().getName());
        }

        public String describe() {
            return "Removing Steam Turbine steam: " + this.input;
        }
    }

    private static class Add
    extends BaseAction {
        private FluidStack input;
        private int time;

        public Add(FluidStack input, int time) {
            super("SteamTurbine");
            this.input = input;
            this.time = time;
        }

        public void apply() {
            SteamHandler.registerSteam((Fluid)this.input.getFluid(), (int)this.time);
        }

        public String describe() {
            return "Registering Steam Turbine steam: " + this.input + " burn time: " + this.time;
        }
    }
}

