/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.forestry;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseAddForestry;
import com.blamejared.mtlib.utils.BaseRemoveForestry;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.api.recipes.IForestryRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.factory.recipes.FabricatorRecipe;
import forestry.factory.recipes.FabricatorSmeltingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.ThermionicFabricator")
@ModOnly(value="forestry")
@ZenRegister
public class ThermionicFabricator {
    public static final String nameSmelting = "Forestry Thermionic Fabricator (Smelting)";
    public static final String nameCasting = "Forestry Thermionic Fabricator (Casting)";

    @ZenMethod
    public static void addSmelting(ILiquidStack liquidStack, IItemStack itemInput, int meltingPoint) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddSmelting((IFabricatorSmeltingRecipe)new FabricatorSmeltingRecipe(InputHelper.toStack((IItemStack)itemInput), InputHelper.toFluid((ILiquidStack)liquidStack), meltingPoint)));
    }

    @ZenMethod
    public static void addCast(IItemStack output, IIngredient[][] ingredients, ILiquidStack liquidStack, @Optional IItemStack plan) {
        ShapedRecipeCustom patternRecipe = new ShapedRecipeCustom(InputHelper.toStack((IItemStack)output), InputHelper.toShapedObjects((IIngredient[][])ingredients));
        NonNullList ingredientsList = patternRecipe.getRawIngredients();
        FabricatorRecipe recipe = new FabricatorRecipe(InputHelper.toStack((IItemStack)plan), InputHelper.toFluid((ILiquidStack)liquidStack), InputHelper.toStack((IItemStack)output), ingredientsList, patternRecipe.getOreDicts(), patternRecipe.getWidth(), patternRecipe.getHeight());
        ModTweaker.LATE_ADDITIONS.add((IAction)new AddCast((IFabricatorRecipe)recipe));
    }

    @ZenMethod
    public static void removeSmelting(IIngredient itemInput) {
        ModTweaker.LATE_REMOVALS.add((IAction)new RemoveSmelting(itemInput));
    }

    @ZenMethod
    public static void removeCast(IIngredient product) {
        ModTweaker.LATE_REMOVALS.add((IAction)new RemoveCasts(product));
    }

    private static class RemoveCasts
    extends BaseRemoveForestry<IFabricatorRecipe> {
        private IIngredient product;

        public RemoveCasts(IIngredient product) {
            super(ThermionicFabricator.nameCasting, (ICraftingProvider)RecipeManagers.fabricatorManager);
            this.product = product;
        }

        public String getRecipeInfo() {
            return this.product.toString();
        }

        public boolean checkIsRecipe(IFabricatorRecipe recipe) {
            return recipe != null && StackHelper.matches((IIngredient)this.product, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.getRecipeOutput()));
        }
    }

    private static class RemoveSmelting
    extends BaseRemoveForestry<IFabricatorSmeltingRecipe> {
        private IIngredient itemInput;

        public RemoveSmelting(IIngredient itemInput) {
            super(ThermionicFabricator.nameSmelting, (ICraftingProvider)RecipeManagers.fabricatorSmeltingManager);
            this.itemInput = itemInput;
        }

        public String getRecipeInfo() {
            return this.itemInput.toString();
        }

        public boolean checkIsRecipe(IFabricatorSmeltingRecipe recipe) {
            return recipe != null && StackHelper.matches((IIngredient)this.itemInput, (IItemStack)InputHelper.toIItemStack((ItemStack)recipe.getResource()));
        }
    }

    private static class AddCast
    extends BaseAddForestry<IFabricatorRecipe> {
        public AddCast(IFabricatorRecipe recipe) {
            super(ThermionicFabricator.nameCasting, (ICraftingProvider)RecipeManagers.fabricatorManager, (IForestryRecipe)recipe);
        }

        public String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)((IFabricatorRecipe)this.recipe).getRecipeOutput());
        }
    }

    private static class AddSmelting
    extends BaseAddForestry<IFabricatorSmeltingRecipe> {
        public AddSmelting(IFabricatorSmeltingRecipe recipe) {
            super(ThermionicFabricator.nameSmelting, (ICraftingProvider)RecipeManagers.fabricatorSmeltingManager, (IForestryRecipe)recipe);
        }

        public String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)((IFabricatorSmeltingRecipe)this.recipe).getResource());
        }
    }
}

