/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.actuallyaddition;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.TreasureChestLoot;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.actuallyadditions.TreasureChest")
@ModOnly(value="actuallyadditions")
@ZenRegister
public class TreasureChest {
    @ZenMethod
    public static void addLoot(IItemStack returnItem, int chance, int minAmount, int maxAmount) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(Collections.singletonList(new TreasureChestLoot(InputHelper.toStack((IItemStack)returnItem), chance, minAmount, maxAmount))));
    }

    @ZenMethod
    public static void removeLoot(IItemStack returnItem) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(returnItem));
    }

    private static class Remove
    extends BaseListRemoval<TreasureChestLoot> {
        private IItemStack output;

        protected Remove(IItemStack output) {
            super("Treasure Chest", ActuallyAdditionsAPI.TREASURE_CHEST_LOOT);
            this.output = output;
        }

        public void apply() {
            ActuallyAdditionsAPI.TREASURE_CHEST_LOOT.forEach(recipe -> {
                if (this.output.matches(InputHelper.toIItemStack((ItemStack)recipe.returnItem))) {
                    this.recipes.add(recipe);
                }
            });
            super.apply();
        }

        protected String getRecipeInfo(TreasureChestLoot recipe) {
            return LogHelper.getStackDescription((Object)recipe.returnItem);
        }
    }

    private static class Add
    extends BaseListAddition<TreasureChestLoot> {
        protected Add(List<TreasureChestLoot> recipes) {
            super("Treasure Chest", ActuallyAdditionsAPI.TREASURE_CHEST_LOOT, recipes);
        }

        protected String getRecipeInfo(TreasureChestLoot recipe) {
            return LogHelper.getStackDescription((Object)recipe.returnItem);
        }
    }
}

