/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.dropt.modules.dropt.rule.drop;

import com.codetaylor.mc.athenaeum.util.WeightedPicker;
import com.codetaylor.mc.dropt.api.reference.EnumDropListStrategy;
import com.codetaylor.mc.dropt.api.reference.EnumDropStrategy;
import com.codetaylor.mc.dropt.api.reference.EnumReplaceStrategy;
import com.codetaylor.mc.dropt.api.reference.EnumXPReplaceStrategy;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.Rule;
import com.codetaylor.mc.dropt.modules.dropt.rule.data.RuleDrop;
import com.codetaylor.mc.dropt.modules.dropt.rule.log.DebugFileWrapper;
import com.codetaylor.mc.dropt.modules.dropt.rule.match.ItemMatchEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DropModifier {
    private static final Random RANDOM = new Random();

    public List<ItemStack> modifyDrops(World world, BlockPos pos, Rule rule, List<ItemStack> currentDrops, boolean isSilkTouching, int fortuneLevel, int experience, DebugFileWrapper logFile, boolean debug) {
        if (debug) {
            logFile.debug("");
        }
        ArrayList<ItemStack> originalDrops = new ArrayList<ItemStack>(currentDrops);
        if (rule.replaceStrategy == EnumReplaceStrategy.REPLACE_ALL) {
            currentDrops.clear();
            if (debug) {
                logFile.debug("[DROP] Cleared drop list, replace strategy: " + (Object)((Object)rule.replaceStrategy));
            }
        }
        WeightedPicker picker = new WeightedPicker();
        if (debug) {
            logFile.debug("[DROP] Selecting drop candidates...");
        }
        int candidatesFound = 0;
        ArrayList<RuleDrop> forcedDrops = new ArrayList<RuleDrop>();
        for (RuleDrop drop : rule.drops) {
            if (drop.force) {
                forcedDrops.add(drop);
                continue;
            }
            if (!drop.selector.isValidCandidate(isSilkTouching, fortuneLevel, logFile, debug)) continue;
            int weight = drop.selector.weight.value + fortuneLevel * drop.selector.weight.fortuneModifier;
            if (weight > 0) {
                picker.add(weight, (Object)drop);
                ++candidatesFound;
                if (!debug) continue;
                logFile.debug("[DROP] Added drop to weighted picker: " + drop.item.toString());
                logFile.debug("[DROP] Added drop using weight value: " + weight);
                continue;
            }
            if (!debug) continue;
            logFile.debug("[DROP] Skipped adding drop " + drop.item.toString() + " to weighted picker due to calculated weight <= 0: " + weight);
        }
        if (picker.getTotal() == 0 && forcedDrops.isEmpty()) {
            if (debug) {
                logFile.debug("[DROP] No valid drop candidates were found");
                logFile.debug("[DROP] Returning drop list: " + currentDrops);
            }
            return currentDrops;
        }
        if (debug) {
            logFile.debug("[DROP] Valid drop candidates found: " + candidatesFound);
            logFile.debug("[DROP] Forced drops found: " + forcedDrops.size());
            logFile.debug("[DROP] Total weight: " + picker.getTotal());
        }
        int dropCount = rule.dropCount.get(RANDOM, fortuneLevel);
        if (debug) {
            logFile.debug("[DROP] Drop count: " + dropCount);
        }
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        ArrayList<RuleDrop> pickedDrops = new ArrayList<RuleDrop>(forcedDrops);
        for (int i = 0; i < dropCount && picker.getSize() != 0; ++i) {
            RuleDrop ruleDrop;
            if (rule.dropStrategy == EnumDropStrategy.UNIQUE) {
                ruleDrop = (RuleDrop)picker.getAndRemove();
                if (debug) {
                    logFile.debug("[DROP] Removed drop from picker: " + ruleDrop.toString());
                }
            } else {
                ruleDrop = (RuleDrop)picker.get();
            }
            pickedDrops.add(ruleDrop);
        }
        IBlockState replaceBlockState = null;
        for (RuleDrop ruleDrop : pickedDrops) {
            int itemQuantity = this.getItemQuantity(fortuneLevel, logFile, debug, originalDrops, ruleDrop);
            if (debug) {
                logFile.debug("[DROP] Selected drop: " + ruleDrop.toString());
                logFile.debug("[DROP] Selected drop quantity: " + itemQuantity);
            }
            if (replaceBlockState == null && ruleDrop.replaceBlock != null && ruleDrop.replaceBlock._blockState != null) {
                replaceBlockState = ruleDrop.replaceBlock._blockState;
                if (debug) {
                    logFile.debug("[DROP] Selected replacement blockState: " + replaceBlockState.toString());
                }
            }
            int xp = ruleDrop.xp.get(RANDOM, fortuneLevel);
            if (ruleDrop.xpReplaceStrategy == EnumXPReplaceStrategy.ADD) {
                xp += experience;
            }
            if (xp > 0) {
                if (debug) {
                    logFile.debug("[DROP] Dropping xp: " + xp);
                }
                while (xp > 0) {
                    int xpDrop = EntityXPOrb.func_70527_a((int)xp);
                    xp -= xpDrop;
                    world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), xpDrop));
                }
            } else if (debug) {
                logFile.debug("[DROP] Dropped zero xp");
            }
            if (itemQuantity <= 0) {
                if (!debug) continue;
                logFile.debug("[DROP] Skipping selected drop due to low item quantity roll: " + itemQuantity);
                continue;
            }
            if (ruleDrop.item._items.isEmpty()) {
                if (!debug) continue;
                logFile.debug("[DROP] Skipping selected drop due to empty drop item list");
                continue;
            }
            if (ruleDrop.item.drop == EnumDropListStrategy.ONE) {
                ItemStack copy = ruleDrop.item._items.get(RANDOM.nextInt(ruleDrop.item._items.size())).func_77946_l();
                this.addDrop(logFile, debug, newDrops, itemQuantity, copy);
                continue;
            }
            for (ItemStack item : ruleDrop.item._items) {
                this.addDrop(logFile, debug, newDrops, itemQuantity, item.func_77946_l());
            }
        }
        if (replaceBlockState != null) {
            world.func_175656_a(pos, replaceBlockState);
        }
        if (rule.replaceStrategy == EnumReplaceStrategy.REPLACE_ALL_IF_SELECTED && !newDrops.isEmpty()) {
            currentDrops.clear();
            if (debug) {
                logFile.debug("[DROP] Cleared drop list, replace strategy: " + (Object)((Object)rule.replaceStrategy));
            }
        }
        boolean removeMatchedItems = false;
        if (rule.replaceStrategy == EnumReplaceStrategy.REPLACE_ITEMS && !rule.match.drops._drops.isEmpty()) {
            removeMatchedItems = true;
        }
        if (rule.replaceStrategy == EnumReplaceStrategy.REPLACE_ITEMS_IF_SELECTED && !newDrops.isEmpty() && !rule.match.drops._drops.isEmpty()) {
            removeMatchedItems = true;
        }
        if (removeMatchedItems) {
            if (debug) {
                logFile.debug("[DROP] Removing all items specified in the item matcher, replace strategy: " + (Object)((Object)rule.replaceStrategy));
            }
            Iterator<ItemStack> it = currentDrops.iterator();
            block5: while (it.hasNext()) {
                ItemStack itemStack = it.next();
                for (ItemMatchEntry itemMatchEntry : rule.match.drops._drops) {
                    if (itemMatchEntry.matches(itemStack, logFile, debug, "[DROP] ")) {
                        it.remove();
                        if (!debug) continue block5;
                        logFile.debug("[DROP] Removed: " + itemStack);
                        continue block5;
                    }
                    if (!debug) continue;
                    logFile.debug("[DROP] Skipping: " + itemStack);
                }
            }
        }
        currentDrops.addAll(newDrops);
        if (debug) {
            logFile.debug("Returning drop list: " + currentDrops);
        }
        return currentDrops;
    }

    private void addDrop(DebugFileWrapper logFile, boolean debug, List<ItemStack> newDrops, int itemQuantity, ItemStack copy) {
        int maxStackSize = copy.func_77976_d();
        if (itemQuantity == 1 && copy.func_190916_E() > 1) {
            itemQuantity = copy.func_190916_E();
        }
        if (itemQuantity > maxStackSize) {
            int remaining;
            for (remaining = itemQuantity; remaining > maxStackSize; remaining -= maxStackSize) {
                ItemStack itemStack = copy.func_77946_l();
                itemStack.func_190920_e(maxStackSize);
                newDrops.add(itemStack);
            }
            if (remaining > 0) {
                copy.func_190920_e(remaining);
                newDrops.add(copy);
            }
        } else {
            copy.func_190920_e(itemQuantity);
            newDrops.add(copy);
        }
        if (debug) {
            logFile.debug("[DROP] Added ItemStack to drop list: " + copy);
        }
    }

    private int getItemQuantity(int fortuneLevel, DebugFileWrapper logFile, boolean debug, List<ItemStack> originalDrops, RuleDrop ruleDrop) {
        int itemQuantity = ruleDrop.item.quantity.get(RANDOM, fortuneLevel);
        if (!ruleDrop.item.matchQuantity._drops.isEmpty() && !originalDrops.isEmpty()) {
            LinkedHashMap<ItemStack, Integer> countMap = new LinkedHashMap<ItemStack, Integer>(originalDrops.size());
            for (ItemStack itemStack : originalDrops) {
                boolean found = false;
                for (Map.Entry entry : countMap.entrySet()) {
                    ItemStack countStack = (ItemStack)entry.getKey();
                    if (countStack.func_77973_b() != itemStack.func_77973_b() || countStack.func_77960_j() != itemStack.func_77960_j()) continue;
                    found = true;
                    countMap.put(countStack, (Integer)entry.getValue() + itemStack.func_190916_E());
                    break;
                }
                if (found) continue;
                countMap.put(itemStack.func_77946_l(), itemStack.func_190916_E());
            }
            if (debug) {
                for (Map.Entry entry : countMap.entrySet()) {
                    logFile.debug("[DROP] Match quantity counted [" + entry.getValue() + "] of [" + entry.getKey() + "]");
                }
            }
            block3: for (Ingredient ingredient : ruleDrop.item.matchQuantity._drops) {
                for (Map.Entry entry : countMap.entrySet()) {
                    ItemStack candidate = (ItemStack)entry.getKey();
                    if (!ingredient.apply(candidate)) continue;
                    itemQuantity = (Integer)entry.getValue();
                    if (!debug) break block3;
                    logFile.debug("[DROP] Selected match quantity [" + itemQuantity + "] from [" + entry.getKey() + "]");
                    break block3;
                }
            }
        }
        return itemQuantity;
    }
}

