/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import com.google.gson.JsonObject;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.JsonContext;
import pl.asie.charset.lib.recipe.IOutputSupplier;
import pl.asie.charset.lib.recipe.IOutputSupplierFactory;
import pl.asie.charset.lib.recipe.IngredientMatcher;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.lib.wires.WireProvider;

public class WireOutputSupplier
implements IOutputSupplier {
    private final ResourceLocation id;
    private final boolean freestanding;
    private final int amount;

    public WireOutputSupplier(ResourceLocation id, boolean freestanding, int amount) {
        this.id = id;
        this.freestanding = freestanding;
        this.amount = amount;
    }

    @Override
    public ItemStack getCraftingResult(RecipeCharset recipe, IngredientMatcher matcher, InventoryCrafting inv) {
        return this.getDefaultOutput();
    }

    @Override
    public ItemStack getDefaultOutput() {
        if (!WireManager.REGISTRY.containsKey(this.id)) {
            return ItemStack.field_190927_a;
        }
        return ((WireProvider)WireManager.REGISTRY.getValue(this.id)).getItemWire().toStack(this.freestanding, this.amount);
    }

    public static class Factory
    implements IOutputSupplierFactory {
        @Override
        public IOutputSupplier parse(JsonContext context, JsonObject json) {
            ResourceLocation id = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"id"));
            boolean freestanding = JsonUtils.func_151209_a((JsonObject)json, (String)"freestanding", (boolean)false);
            int amount = JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1);
            return new WireOutputSupplier(id, freestanding, amount);
        }
    }
}

