/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcmultipart.api.multipart.MultipartHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.render.model.IRenderComparable;
import pl.asie.charset.lib.scheduler.Scheduler;
import pl.asie.charset.lib.utils.MultipartUtils;
import pl.asie.charset.lib.utils.UnlistedPropertyGeneric;
import pl.asie.charset.lib.wires.BlockWire;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.WireNeighborWHCache;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireUtils;

public abstract class Wire
implements ICapabilityProvider,
IRenderComparable<Wire> {
    public static final IUnlistedProperty<Wire> PROPERTY = new UnlistedPropertyGeneric<Wire>("wire", Wire.class);
    @Nonnull
    private final IWireContainer container;
    @Nonnull
    private final WireProvider factory;
    @Nonnull
    private final WireFace location;
    @Nullable
    private final CapabilityDispatcher capabilities;
    private WireNeighborWHCache neighborWHCache;
    private byte internalConnections;
    private byte externalConnections;
    private byte cornerConnections;
    private byte occludedSides;
    private byte cornerOccludedSides;

    protected Wire(@Nonnull IWireContainer container, @Nonnull WireProvider factory, @Nonnull WireFace location) {
        this.container = container;
        this.factory = factory;
        this.location = location;
        AttachCapabilitiesEvent event = new AttachCapabilitiesEvent(Wire.class, (Object)this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities()) : null;
    }

    protected final void scheduleConnectionUpdate() {
        Scheduler.INSTANCE.in(MultipartHelper.unwrapWorld((World)this.getContainer().world()), 0, this::updateConnections);
    }

    private ICapabilityProvider getCapabilityProviderRemoteBlock(BlockPos pos) {
        return WireUtils.getCapabilityProvider(this, pos, true);
    }

    private ICapabilityProvider getCapabilityProviderRemote(BlockPos pos, WireFace face, boolean blocks) {
        Wire wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), pos, face);
        if (wire != null) {
            return wire;
        }
        if (blocks) {
            return this.getCapabilityProviderRemoteBlock(pos);
        }
        return null;
    }

    private <T> T getCapabilityRemoteBlock(BlockPos pos, EnumFacing facing, Capability<T> capability) {
        return WireUtils.getCapability(this, pos, capability, facing, true);
    }

    private <T> T getCapabilityRemote(BlockPos pos, WireFace face, EnumFacing facing, boolean blocks, Capability<T> capability) {
        Wire wire = WireUtils.getWire((IBlockAccess)this.getContainer().world(), pos, face);
        if (wire != null && wire.hasCapability(capability, facing)) {
            return wire.getCapability(capability, facing);
        }
        if (blocks) {
            return this.getCapabilityRemoteBlock(pos, facing, capability);
        }
        return null;
    }

    protected final Iterable<Pair<ICapabilityProvider, EnumFacing>> connectedIterator(final boolean connectsBelowWire) {
        return () -> new Iterator<Pair<ICapabilityProvider, EnumFacing>>(){
            private final BlockPos pos;
            private final WireFace loc;
            private int i;
            private Pair queued;
            {
                this.pos = Wire.this.getContainer().pos();
                this.loc = Wire.this.getLocation();
                this.queued = this.find();
                this.i = 0;
            }

            private Pair<ICapabilityProvider, EnumFacing> find() {
                ICapabilityProvider result = null;
                EnumFacing resultFace = null;
                while (result == null && this.i < 20) {
                    switch (this.i) {
                        case 0: {
                            if (Wire.this.getLocation() == WireFace.CENTER || !connectsBelowWire) break;
                            result = Wire.this.getCapabilityProviderRemoteBlock(this.pos.func_177972_a(this.loc.facing));
                            resultFace = this.loc.facing.func_176734_d();
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            WireFace face = WireFace.VALUES[this.i - 1];
                            if (face == this.loc || !Wire.this.connectsInternal(face)) break;
                            result = Wire.this.getCapabilityProviderRemote(this.pos, face, false);
                            resultFace = Wire.this.getLocation().facing.func_176734_d();
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            EnumFacing facing = EnumFacing.func_82600_a((int)(this.i - 8));
                            if (!Wire.this.connectsExternal(facing)) break;
                            result = Wire.this.getCapabilityProviderRemote(this.pos.func_177972_a(facing), this.loc, true);
                            resultFace = facing.func_176734_d();
                            break;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: {
                            EnumFacing facing = EnumFacing.func_82600_a((int)(this.i - 14));
                            if (!Wire.this.connectsCorner(facing)) break;
                            result = Wire.this.getCapabilityProviderRemote(this.pos.func_177972_a(facing).func_177972_a(this.loc.facing), WireFace.get(facing.func_176734_d()), false);
                            resultFace = this.loc.facing.func_176734_d();
                        }
                    }
                    ++this.i;
                }
                return result != null ? Pair.of(result, resultFace) : null;
            }

            @Override
            public boolean hasNext() {
                return this.queued != null;
            }

            @Override
            public Pair<ICapabilityProvider, EnumFacing> next() {
                Pair current = this.queued;
                this.queued = this.find();
                return current;
            }
        };
    }

    protected final <T> Iterable<T> connectedIterator(final Capability<T> capability, final boolean connectsBelowWire) {
        return () -> new Iterator<T>(){
            private final BlockPos pos;
            private final WireFace loc;
            private int i;
            private Object queued;
            {
                this.pos = Wire.this.getContainer().pos();
                this.loc = Wire.this.getLocation();
                this.queued = this.find();
                this.i = 0;
            }

            private T find() {
                Object result = null;
                while (result == null && this.i < 20) {
                    switch (this.i) {
                        case 0: {
                            if (Wire.this.getLocation() == WireFace.CENTER || !connectsBelowWire) break;
                            result = Wire.this.getCapabilityRemoteBlock(this.pos.func_177972_a(this.loc.facing), this.loc.facing.func_176734_d(), capability);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            WireFace face = WireFace.VALUES[this.i - 1];
                            if (face == this.loc || !Wire.this.connectsInternal(face)) break;
                            result = Wire.this.getCapabilityRemote(this.pos, face, Wire.this.getLocation().facing, false, capability);
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: {
                            EnumFacing facing = EnumFacing.func_82600_a((int)(this.i - 8));
                            if (!Wire.this.connectsExternal(facing)) break;
                            result = Wire.this.getCapabilityRemote(this.pos.func_177972_a(facing), this.loc, facing.func_176734_d(), true, capability);
                            break;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: {
                            EnumFacing facing = EnumFacing.func_82600_a((int)(this.i - 14));
                            if (!Wire.this.connectsCorner(facing)) break;
                            result = Wire.this.getCapabilityRemote(this.pos.func_177972_a(facing).func_177972_a(this.loc.facing), WireFace.get(facing.func_176734_d()), this.loc.facing.func_176734_d(), false, capability);
                        }
                    }
                    ++this.i;
                }
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.queued != null;
            }

            @Override
            public T next() {
                Object current = this.queued;
                this.queued = this.find();
                return current;
            }
        };
    }

    WireNeighborWHCache getNeighborWHCache() {
        if (this.getContainer().world() == null) {
            return null;
        }
        if (this.connectsAnyInternal() && this.neighborWHCache == null) {
            this.neighborWHCache = new WireNeighborWHCache((IBlockAccess)this.getContainer().world(), this.getContainer().pos(), this);
        }
        return this.neighborWHCache;
    }

    public void readNBTData(NBTTagCompound nbt, boolean isClient) {
        byte oldIC = this.internalConnections;
        this.internalConnections = nbt.func_74771_c("iC");
        this.externalConnections = nbt.func_74771_c("eC");
        this.cornerConnections = nbt.func_74764_b("cC") ? nbt.func_74771_c("cC") : (byte)0;
        this.occludedSides = nbt.func_74764_b("oS") ? nbt.func_74771_c("oS") : (byte)0;
        byte by = this.cornerOccludedSides = nbt.func_74764_b("coS") ? nbt.func_74771_c("coS") : (byte)0;
        if (oldIC != this.internalConnections) {
            this.neighborWHCache = null;
        }
    }

    public NBTTagCompound writeNBTData(NBTTagCompound nbt, boolean isClient) {
        nbt.func_74774_a("oS", this.occludedSides);
        nbt.func_74774_a("coS", this.cornerOccludedSides);
        nbt.func_74774_a("iC", this.internalConnections);
        nbt.func_74774_a("eC", this.externalConnections);
        if (this.location != WireFace.CENTER) {
            nbt.func_74774_a("cC", this.cornerConnections);
        }
        return nbt;
    }

    public void onChanged(boolean external) {
        boolean remote = this.getContainer().world().field_72995_K;
        if (external && !remote && !this.factory.canPlace((IBlockAccess)this.getContainer().world(), this.getContainer().pos(), this.location)) {
            this.getContainer().dropWire();
        }
        this.scheduleConnectionUpdate();
    }

    public int getRenderColor() {
        return -1;
    }

    public final IWireContainer getContainer() {
        return this.container;
    }

    public final WireProvider getProvider() {
        return this.factory;
    }

    public final WireFace getLocation() {
        return this.location;
    }

    public final boolean connectsAnyInternal() {
        return (this.internalConnections & 0x7F) != 0;
    }

    public final boolean connectsInternal(EnumFacing side) {
        return (this.internalConnections & 1 << side.ordinal()) != 0;
    }

    public final boolean connectsInternal(WireFace side) {
        return (this.internalConnections & 1 << side.ordinal()) != 0;
    }

    public final boolean connectsAnyExternal() {
        return (this.externalConnections & 0x3F) != 0;
    }

    public final boolean connectsExternal(EnumFacing side) {
        return (this.externalConnections & 1 << side.ordinal()) != 0;
    }

    public final boolean connectsAny(EnumFacing direction) {
        return ((this.internalConnections | this.externalConnections | this.cornerConnections) & 1 << (direction != null ? direction.ordinal() : 6)) != 0;
    }

    public final boolean connectsAnyCorner() {
        return (this.cornerConnections & 0x3F) != 0;
    }

    public final boolean connectsCorner(EnumFacing direction) {
        return (this.cornerConnections & 1 << direction.ordinal()) != 0;
    }

    public final boolean connects(EnumFacing direction) {
        return ((this.internalConnections | this.externalConnections) & 1 << (direction != null ? direction.ordinal() : 6)) != 0;
    }

    public final boolean isOccluded(EnumFacing face) {
        return (this.occludedSides & 1 << face.ordinal()) != 0;
    }

    public final boolean isCornerOccluded(EnumFacing face) {
        return this.isOccluded(face) || (this.cornerOccludedSides & 1 << face.ordinal()) != 0;
    }

    protected void updateConnections() {
        AxisAlignedBB mask;
        EnumSet<WireFace> validSides = EnumSet.noneOf(WireFace.class);
        EnumSet<WireFace> invalidCornerSides = EnumSet.noneOf(WireFace.class);
        for (WireFace facing : WireFace.VALUES) {
            if (facing == this.location || facing != WireFace.CENTER && this.location != WireFace.CENTER && this.location.facing.func_176740_k() == facing.facing.func_176740_k()) continue;
            validSides.add(facing);
        }
        int oldConnectionCache = this.getConnectionMask();
        this.cornerOccludedSides = 0;
        this.occludedSides = 0;
        this.cornerConnections = 0;
        this.externalConnections = 0;
        this.internalConnections = 0;
        EnumFacing[] connFaces = WireUtils.getConnectionsForRender(this.location);
        for (int i = 0; i < connFaces.length; ++i) {
            WireFace face = WireFace.get(connFaces[i]);
            if (!validSides.contains((Object)face)) continue;
            boolean found = false;
            AxisAlignedBB mask2 = this.factory.getBox(this.location, i + 1);
            if (mask2 == null || !MultipartUtils.INSTANCE.intersects(Collections.singletonList(mask2), (IBlockAccess)this.container.world(), this.container.pos(), state -> !(state.func_177230_c() instanceof BlockWire))) continue;
            this.occludedSides = (byte)(this.occludedSides | 1 << connFaces[i].ordinal());
            validSides.remove((Object)face);
            found = true;
        }
        if (validSides.contains((Object)WireFace.CENTER) && (mask = this.factory.getBox(WireFace.CENTER, 1 + this.location.ordinal())) != null && MultipartUtils.INSTANCE.intersects(Collections.singletonList(mask), (IBlockAccess)this.container.world(), this.container.pos(), state -> !(state.func_177230_c() instanceof BlockWire))) {
            this.occludedSides = (byte)(this.occludedSides | 0x40);
            validSides.remove((Object)WireFace.CENTER);
        }
        for (WireFace facing : validSides) {
            if (WireUtils.canConnectInternal(this, facing)) {
                this.internalConnections = (byte)(this.internalConnections | 1 << facing.ordinal());
                continue;
            }
            if (facing == WireFace.CENTER) continue;
            if (WireUtils.canConnectExternal(this, facing.facing)) {
                this.externalConnections = (byte)(this.externalConnections | 1 << facing.ordinal());
                continue;
            }
            if (this.location == WireFace.CENTER || invalidCornerSides.contains((Object)facing) || !WireUtils.canConnectCorner(this, facing.facing)) continue;
            this.cornerConnections = (byte)(this.cornerConnections | 1 << facing.ordinal());
        }
        int newConnectionCache = this.getConnectionMask();
        if (oldConnectionCache != newConnectionCache) {
            this.container.requestNeighborUpdate(oldConnectionCache ^ newConnectionCache);
            this.container.requestRenderUpdate();
        }
        this.neighborWHCache = null;
    }

    protected int getWeakPower(EnumFacing side) {
        return 0;
    }

    protected int getStrongPower(EnumFacing side) {
        return 0;
    }

    protected int getConnectionMask() {
        return this.internalConnections | this.externalConnections << 8 | this.cornerConnections << 16;
    }

    protected boolean canConnectWire(Wire wire) {
        return wire.getProvider() == this.getProvider();
    }

    public boolean canConnectRedstone(EnumFacing side) {
        return false;
    }

    public boolean shouldCheckWeakPower(EnumFacing side) {
        return false;
    }

    protected boolean canConnectBlock(BlockPos pos, EnumFacing direction) {
        return false;
    }

    public void setConnectionsForItemRender() {
        this.internalConnections = (byte)63;
        this.externalConnections = 0;
        this.cornerConnections = 0;
    }

    @Override
    public boolean renderEquals(Wire other) {
        if (other.factory != this.factory || other.location != this.location || other.internalConnections != this.internalConnections || other.externalConnections != this.externalConnections || other.cornerConnections != this.cornerConnections) {
            return false;
        }
        WireNeighborWHCache cache1 = this.getNeighborWHCache();
        WireNeighborWHCache cache2 = other.getNeighborWHCache();
        if (cache1 != null || cache2 != null) {
            if (cache1 == null || cache2 == null) {
                return false;
            }
            if (!cache1.renderEquals(cache2)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int renderHashCode() {
        return Objects.hash(new Object[]{this.factory, this.location, this.internalConnections, this.externalConnections, this.cornerConnections, this.neighborWHCache != null ? this.neighborWHCache.renderHashCode() : 0});
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.connects(facing)) {
            return this.capabilities != null && this.capabilities.hasCapability(capability, facing);
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.connects(facing)) {
            return (T)(this.capabilities != null ? this.capabilities.getCapability(capability, facing) : null);
        }
        return null;
    }

    public abstract String getDisplayName();
}

