/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import pl.asie.charset.lib.recipe.IRecipeResultBuilder;
import pl.asie.charset.lib.recipe.OutputSupplier;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.recipe.ingredient.IngredientCharset;
import pl.asie.charset.lib.wires.ItemWire;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.lib.wires.WireProvider;

public class RecipeWireConversion
extends RecipeCharset {
    private final int outputOffset;

    private static List<ItemStack> getMatchingStacks(int offset) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (WireProvider provider : WireManager.REGISTRY) {
            if (!provider.hasItemWire() || !provider.hasSidedWire() || !provider.hasFreestandingWire()) continue;
            stacks.add(new ItemStack((Item)provider.getItemWire(), 1, offset));
        }
        return stacks;
    }

    public RecipeWireConversion(boolean freestanding) {
        super("charset:wire_convert", true);
        this.input = NonNullList.func_191196_a();
        this.input.add((Object)IngredientCharset.wrap(new IngredientWires(freestanding)));
        this.output = OutputSupplier.createStackOutputSupplier(ItemStack.field_190927_a);
        this.width = 1;
        this.height = 1;
        this.outputOffset = freestanding ? 0 : 1;
    }

    public List<ItemStack> getAllRecipeOutputs() {
        return RecipeWireConversion.getMatchingStacks(this.outputOffset);
    }

    @Override
    public ItemStack func_77572_b(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(1);
            newStack.func_77964_b(newStack.func_77952_i() ^ 1);
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    public static class IngredientWires
    extends IngredientCharset {
        private final int offset;

        protected IngredientWires(boolean freestanding) {
            this.offset = freestanding ? 1 : 0;
        }

        @Override
        public boolean arePermutationsDistinct() {
            return true;
        }

        @Override
        protected ItemStack[][] createMatchingStacks() {
            List stacks = RecipeWireConversion.getMatchingStacks(this.offset);
            ItemStack[][] stackArray = new ItemStack[stacks.size()][1];
            for (int i = 0; i < stacks.size(); ++i) {
                stackArray[i][0] = (ItemStack)stacks.get(i);
            }
            return stackArray;
        }

        @Override
        public boolean hasMatchingStacks() {
            return true;
        }

        @Override
        public boolean matches(ItemStack stack, IRecipeResultBuilder builder) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemWire && (stack.func_77960_j() & 1) == this.offset) {
                WireProvider provider = ((ItemWire)stack.func_77973_b()).getWireProvider();
                return provider.hasFreestandingWire() && provider.hasSidedWire();
            }
            return false;
        }
    }
}

