/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils.colorspace;

final class ColorspaceFunctions {
    private static final float[] D65_WHITE = new float[]{0.9504f, 1.0f, 1.0888f};
    private static final float E = 0.008856f;
    private static final float K = 903.3f;
    private static final float KE = 7.999625f;
    private static final float E_CBRT = 0.20689304f;

    ColorspaceFunctions() {
    }

    public static float[] XYZtoLAB(float[] v) {
        float xr = v[0] / D65_WHITE[0];
        float yr = v[1] / D65_WHITE[1];
        float zr = v[2] / D65_WHITE[2];
        float fx = xr > 0.008856f ? (float)Math.cbrt(xr) : (903.3f * xr + 16.0f) / 116.0f;
        float fy = yr > 0.008856f ? (float)Math.cbrt(yr) : (903.3f * yr + 16.0f) / 116.0f;
        float fz = zr > 0.008856f ? (float)Math.cbrt(zr) : (903.3f * zr + 16.0f) / 116.0f;
        return new float[]{116.0f * fy - 16.0f, 500.0f * (fx - fy), 200.0f * (fy - fz)};
    }

    public static float[] LABtoXYZ(float[] v) {
        float yr;
        float zr;
        float fy = (v[0] + 16.0f) / 116.0f;
        float fx = v[1] / 500.0f + fy;
        float fz = fy - v[2] / 200.0f;
        float xr = fx > 0.20689304f ? fx * fx * fx : (116.0f * fx - 16.0f) / 903.3f;
        float f = zr = fz > 0.20689304f ? fz * fz * fz : (116.0f * fz - 16.0f) / 903.3f;
        if (v[0] > 7.999625f) {
            yr = (v[0] + 16.0f) / 116.0f;
            yr *= yr * yr;
        } else {
            yr = v[0] / 903.3f;
        }
        return new float[]{xr * D65_WHITE[0], yr * D65_WHITE[1], zr * D65_WHITE[2]};
    }

    public static float[] sRGBtoXYZ(float[] v) {
        return new float[]{(float)(0.4124564 * (double)v[0] + 0.3575761 * (double)v[1] + 0.1804375 * (double)v[2]), (float)(0.2126729 * (double)v[0] + 0.7151522 * (double)v[1] + 0.072175 * (double)v[2]), (float)(0.0193339 * (double)v[0] + 0.119192 * (double)v[1] + 0.9503041 * (double)v[2])};
    }

    public static float[] XYZtosRGB(float[] v) {
        return new float[]{(float)(3.2404542 * (double)v[0] + -1.5371385 * (double)v[1] + -0.4985314 * (double)v[2]), (float)(-0.969266 * (double)v[0] + 1.8760108 * (double)v[1] + 0.041556 * (double)v[2]), (float)(0.0556434 * (double)v[0] + -0.2040259 * (double)v[1] + 1.0572252 * (double)v[2])};
    }

    public static float[] sRGBtoYUV(float[] v) {
        return new float[]{0.299f * v[0] + 0.587f * v[1] + 0.114f * v[2], -0.147f * v[0] - 0.289f * v[1] + 0.436f * v[2], 0.615f * v[0] - 0.515f * v[1] - 0.1f * v[2]};
    }

    public static float[] YUVtosRGB(float[] v) {
        return new float[]{v[0] + 1.14f * v[2], v[0] - 0.395f * v[1] - 0.581f * v[2], v[0] + 2.032f * v[1]};
    }

    public static float[] sRGBtoYIQ(float[] v) {
        return new float[]{0.299f * v[0] + 0.587f * v[1] + 0.114f * v[2], 0.596f * v[0] - 0.274f * v[1] - 0.322f * v[2], 0.211f * v[0] - 0.523f * v[1] + 0.312f * v[2]};
    }

    public static float[] sRGBtoWeightedRGB(float[] v) {
        return new float[]{(float)Math.sqrt(2.0f + v[0] / 255.0f) * v[0], 2.0f * v[1], (float)Math.sqrt(3.0f - v[0] / 255.0f) * v[2]};
    }
}

