/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultipartUtils {
    public static MultipartUtils INSTANCE = new MultipartUtils();

    protected MultipartUtils() {
    }

    public ExtendedRayTraceResult getTrueResult(RayTraceResult result) {
        return new ExtendedRayTraceResult(result);
    }

    public boolean intersects(Collection<AxisAlignedBB> boxes1, Collection<AxisAlignedBB> boxes2) {
        return boxes1.stream().anyMatch(b1 -> boxes2.stream().anyMatch(arg_0 -> ((AxisAlignedBB)b1).func_72326_a(arg_0)));
    }

    public boolean intersects(Collection<AxisAlignedBB> boxes1, AxisAlignedBB box2) {
        return boxes1.stream().anyMatch(arg_0 -> ((AxisAlignedBB)box2).func_72326_a(arg_0));
    }

    public boolean intersects(Collection<AxisAlignedBB> boxes1, IBlockAccess world, BlockPos pos, Predicate<IBlockState> checkPredicate) {
        if (boxes1.isEmpty()) {
            return false;
        }
        if (world instanceof World) {
            ArrayList<AxisAlignedBB> boxes2 = new ArrayList<AxisAlignedBB>();
            AxisAlignedBB collisionBox = null;
            for (AxisAlignedBB box : boxes1) {
                if (collisionBox == null) {
                    collisionBox = box;
                    continue;
                }
                collisionBox = collisionBox.func_111270_a(box);
            }
            IBlockState state = world.func_180495_p(pos);
            if (checkPredicate.test(state)) {
                state.func_185908_a((World)world, pos, collisionBox.func_186670_a(pos), boxes2, null, false);
            }
            if (boxes2.size() > 0) {
                BlockPos negPos = new BlockPos(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p());
                for (int i = 0; i < boxes2.size(); ++i) {
                    boxes2.set(i, ((AxisAlignedBB)boxes2.get(i)).func_186670_a(negPos));
                }
                return this.intersects(boxes1, boxes2);
            }
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        return checkPredicate.test(state) && this.intersects(boxes1, state.func_185900_c(world, pos));
    }

    public static class ExtendedRayTraceResult
    extends RayTraceResult {
        protected TileEntity tile;
        protected boolean hasTile;

        public ExtendedRayTraceResult(RayTraceResult result) {
            super(result.field_72313_a, result.field_72307_f, result.field_178784_b, result.func_178782_a());
            this.field_72308_g = result.field_72308_g;
            this.subHit = result.subHit;
            this.hitInfo = result.hitInfo;
        }

        public ExtendedRayTraceResult(RayTraceResult result, TileEntity tile) {
            this(result);
            this.hasTile = true;
            this.tile = tile;
        }

        public TileEntity getTile(IBlockAccess world) {
            if (this.hasTile) {
                return this.tile;
            }
            if (this.field_72313_a == RayTraceResult.Type.BLOCK) {
                return world.func_175625_s(this.func_178782_a());
            }
            return null;
        }
    }
}

