/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.resources;

import com.google.common.collect.ImmutableSet;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;

public class CharsetFakeResourcePack
implements IResourcePack,
ISelectiveResourceReloadListener {
    public static final CharsetFakeResourcePack INSTANCE = new CharsetFakeResourcePack();
    private final Map<ResourceLocation, byte[]> data = new HashMap<ResourceLocation, byte[]>();
    private final Map<ResourceLocation, Consumer<DataOutputStream>> entries = new HashMap<ResourceLocation, Consumer<DataOutputStream>>();
    private final Set<String> domains = ImmutableSet.of((Object)"charset_generated");

    private CharsetFakeResourcePack() {
    }

    public void registerEntry(ResourceLocation location, Consumer<DataOutputStream> provider) {
        this.entries.put(location, provider);
    }

    public InputStream func_110590_a(ResourceLocation location) throws IOException {
        if (!this.data.containsKey(location)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.entries.get(location).accept(dataOutputStream);
            dataOutputStream.close();
            byteArrayOutputStream.close();
            byte[] out = byteArrayOutputStream.toByteArray();
            this.data.put(location, out);
            return new ByteArrayInputStream(out);
        }
        return new ByteArrayInputStream(this.data.get(location));
    }

    public boolean func_110589_b(ResourceLocation location) {
        return this.entries.containsKey(location);
    }

    public Set<String> func_110587_b() {
        return this.domains;
    }

    @Nullable
    public <T extends IMetadataSection> T func_135058_a(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "CharsetFakePack";
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.invalidate();
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        Iterator<ResourceLocation> keys = this.data.keySet().iterator();
        while (keys.hasNext()) {
            ResourceLocation key = keys.next();
            String kp = key.func_110623_a();
            boolean remove = true;
            if (kp.startsWith("lang/") || kp.startsWith("texts/")) {
                remove = resourcePredicate.test((IResourceType)VanillaResourceType.LANGUAGES);
            } else if (kp.startsWith("sound")) {
                remove = resourcePredicate.test((IResourceType)VanillaResourceType.SOUNDS);
            } else if (kp.startsWith("textures/") || kp.startsWith("models/") || kp.startsWith("blockstates/")) {
                remove = resourcePredicate.test((IResourceType)VanillaResourceType.MODELS) || resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES);
            } else if (kp.startsWith("shaders/")) {
                remove = resourcePredicate.test((IResourceType)VanillaResourceType.SHADERS);
            }
            if (!remove) continue;
            keys.remove();
        }
    }

    public void clearTexturesFromManager() {
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        if (manager == null) {
            return;
        }
        for (ResourceLocation location : this.entries.keySet()) {
            ITextureObject object;
            if (!location.func_110623_a().startsWith("textures/") || (object = manager.func_110581_b(location)) == null) continue;
            manager.func_110579_a(location, object);
        }
    }

    public void invalidate() {
        this.data.clear();
    }
}

