/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render.sprite;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import pl.asie.charset.lib.utils.MethodHandleHelper;

public class TextureAtlasSpriteCustom
extends TextureAtlasSprite {
    private static final MethodHandle ANIMATION_METADATA_SETTER = MethodHandleHelper.findFieldSetter(TextureAtlasSprite.class, "animationMetadata", "field_110982_k");

    protected TextureAtlasSpriteCustom(String spriteName) {
        super(spriteName);
    }

    public void func_188538_a(PngSizeInfo sizeInfo, boolean isAnimation) throws IOException {
        if (sizeInfo.field_188533_a == sizeInfo.field_188534_b || isAnimation) {
            super.func_188538_a(sizeInfo, isAnimation);
            return;
        }
        try {
            ANIMATION_METADATA_SETTER.invokeExact(this, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.func_110968_a(Lists.newArrayList());
        this.field_110973_g = 0;
        this.field_110983_h = 0;
        this.field_130223_c = sizeInfo.field_188533_a;
        this.field_130224_d = sizeInfo.field_188534_b;
        if (isAnimation) {
            this.field_130224_d = this.field_130223_c;
        }
    }

    protected void addFrameTextureData(int width, int height, int[] pixels) {
        this.addFrameTextureData(width, height, pixels, null);
    }

    protected void addFrameTextureData(int width, int height, int[] pixels, @Nullable IResource resource) {
        AnimationMetadataSection section = resource != null ? (AnimationMetadataSection)resource.func_110526_a("animation") : null;
        this.func_130103_l();
        if (section == null) {
            this.func_110966_b(width);
            this.func_110969_c(height);
            int[][] pixelsCtr = new int[Minecraft.func_71410_x().func_147117_R().getMipmapLevels() + 1][];
            pixelsCtr[0] = pixels;
            this.field_110976_a.add(pixelsCtr);
        } else {
            this.func_110966_b(width);
            this.func_110969_c(width);
            int i = height / width;
            if (section.func_110473_c() > 0) {
                for (Integer index : section.func_130073_e()) {
                    if (index >= i) {
                        throw new RuntimeException("invalid frameindex " + index);
                    }
                    while (this.field_110976_a.size() <= index) {
                        this.field_110976_a.add(null);
                    }
                    int[] data = new int[width * width];
                    int[][] container = new int[Minecraft.func_71410_x().func_147117_R().getMipmapLevels() + 1][];
                    System.arraycopy(pixels, width * width * index, data, 0, width * width);
                    container[0] = data;
                    this.field_110976_a.set(index, container);
                }
            } else {
                ArrayList<AnimationFrame> frames = new ArrayList<AnimationFrame>(i);
                for (int index = 0; index < i; ++index) {
                    int[] data = new int[width * width];
                    int[][] container = new int[Minecraft.func_71410_x().func_147117_R().getMipmapLevels() + 1][];
                    System.arraycopy(pixels, width * width * index, data, 0, width * width);
                    container[0] = data;
                    this.field_110976_a.add(container);
                    frames.add(new AnimationFrame(index, -1));
                }
                section = new AnimationMetadataSection(frames, width, height, section.func_110469_d(), section.func_177219_e());
            }
            try {
                ANIMATION_METADATA_SETTER.invokeExact(this, section);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

