/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render.model;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import pl.asie.charset.lib.render.model.SimpleBakedModel;

public class SimpleMultiLayerBakedModel
extends SimpleBakedModel {
    private final Table<BlockRenderLayer, EnumFacing, List<BakedQuad>> quads = Tables.newCustomTable(new EnumMap(BlockRenderLayer.class), () -> new EnumMap(EnumFacing.class));
    private final Map<BlockRenderLayer, List<BakedQuad>> quadsUnsided = new EnumMap<BlockRenderLayer, List<BakedQuad>>(BlockRenderLayer.class);

    public SimpleMultiLayerBakedModel() {
    }

    public SimpleMultiLayerBakedModel(IBakedModel parent) {
        super(parent);
    }

    public void addQuad(BlockRenderLayer layer, EnumFacing side, BakedQuad quad) {
        if (side == null) {
            this.quadsUnsided.computeIfAbsent(layer, a -> new ArrayList()).add(quad);
        } else {
            ArrayList<BakedQuad> list = (ArrayList<BakedQuad>)this.quads.get((Object)layer, (Object)side);
            if (list == null) {
                list = new ArrayList<BakedQuad>();
                this.quads.put((Object)layer, (Object)side, list);
            }
            list.add(quad);
        }
        this.addQuad(side, quad);
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (layer != null) {
            if (side != null) {
                List<BakedQuad> list = (List<BakedQuad>)this.quads.get((Object)layer, (Object)side);
                return list != null ? list : Collections.emptyList();
            }
            return this.quadsUnsided.getOrDefault(layer, Collections.emptyList());
        }
        return super.func_188616_a(state, side, rand);
    }
}

