/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe.ingredient;

import gnu.trove.set.TCharSet;
import gnu.trove.set.hash.TCharHashSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import pl.asie.charset.lib.recipe.IRecipeResultBuilder;
import pl.asie.charset.lib.recipe.IRecipeView;
import pl.asie.charset.lib.recipe.ingredient.IngredientWrapper;
import pl.asie.charset.lib.utils.ItemUtils;

public abstract class IngredientCharset {
    private static final Map<IngredientCharset, MatchingStacks> MATCHING_STACK_CACHE = new HashMap<IngredientCharset, MatchingStacks>();
    private static final TCharSet EMPTY_CHAR_SET = new TCharHashSet();

    private MatchingStacks getMatchingStacksObj() {
        MatchingStacks ms = MATCHING_STACK_CACHE.get(this);
        if (ms == null) {
            ms = new MatchingStacks(this.createMatchingStacks());
            MATCHING_STACK_CACHE.put(this, ms);
        }
        return ms;
    }

    public final ItemStack[][] getMatchingStacks() {
        return this.getMatchingStacksObj().matchingStacks;
    }

    ItemStack[] getMatchingStacksCompressed() {
        return this.getMatchingStacksObj().getMatchingStacksCompressed();
    }

    IntList getValidItemStacksPacked() {
        return this.getMatchingStacksObj().getValidItemStacksPacked();
    }

    public void onAdded(IRecipeView view) {
    }

    public boolean arePermutationsDistinct() {
        return false;
    }

    public boolean matchSameGrid(ItemStack a, ItemStack b) {
        return !this.arePermutationsDistinct() || ItemUtils.canMerge(a, b);
    }

    public abstract boolean matches(ItemStack var1, IRecipeResultBuilder var2);

    public ItemStack transform(ItemStack stack, ItemStack source, IRecipeResultBuilder builder) {
        return stack;
    }

    protected abstract ItemStack[][] createMatchingStacks();

    public abstract boolean hasMatchingStacks();

    public TCharSet getDependencies() {
        return EMPTY_CHAR_SET;
    }

    public static final Ingredient wrap(IngredientCharset ingredient) {
        return new IngredientWrapper(ingredient);
    }

    public void invalidate() {
        MATCHING_STACK_CACHE.remove(this);
    }

    static class MatchingStacks {
        private ItemStack[][] matchingStacks;
        private ItemStack[] matchingStacksCompressed;
        private IntList matchingStacksPacked;

        MatchingStacks(ItemStack[][] matchingStacks) {
            this.matchingStacks = matchingStacks;
        }

        ItemStack[] getMatchingStacksCompressed() {
            if (this.matchingStacksCompressed == null) {
                int i = 0;
                int length = 0;
                for (ItemStack[] array : this.matchingStacks) {
                    length += array.length;
                }
                ItemStack[] stacks = new ItemStack[length];
                for (ItemStack[] array : this.matchingStacks) {
                    System.arraycopy(array, 0, stacks, i, array.length);
                    i += array.length;
                }
                this.matchingStacksCompressed = stacks;
            }
            return this.matchingStacksCompressed;
        }

        IntList getValidItemStacksPacked() {
            if (this.matchingStacksPacked == null) {
                this.getMatchingStacksCompressed();
                this.matchingStacksPacked = new IntArrayList(this.matchingStacks.length);
                for (int i = 0; i < this.matchingStacksCompressed.length; ++i) {
                    ItemStack itemstack = this.matchingStacksCompressed[i];
                    this.matchingStacksPacked.add(RecipeItemHelper.func_194113_b((ItemStack)itemstack));
                }
                this.matchingStacksPacked.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
            }
            return this.matchingStacksPacked;
        }
    }
}

