/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.oredict.OreIngredient;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.recipe.ingredient.IngredientCharset;
import pl.asie.charset.lib.recipe.ingredient.IngredientWrapper;

public class InventoryCraftingIterator
extends InventoryCrafting
implements Iterator<InventoryCrafting> {
    protected final RecipeCharset recipe;
    protected final Map<Ingredient, Object> permutatingIngredients = new LinkedHashMap<Ingredient, Object>();
    protected final Object[] inputReal;
    protected int i;
    protected int permutations;

    public InventoryCraftingIterator(RecipeCharset recipe, boolean permutateAll) {
        super(new net.minecraft.inventory.Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return false;
            }
        }, recipe.width, recipe.height);
        this.recipe = recipe;
        this.i = 0;
        this.permutations = 1;
        this.inputReal = new Object[recipe.input.size()];
        for (int i = 0; i < recipe.input.size(); ++i) {
            Class<?> c;
            Ingredient ing = (Ingredient)recipe.input.get(i);
            if (this.permutatingIngredients.containsKey(ing)) continue;
            if (ing instanceof IngredientWrapper && !permutateAll) {
                ItemStack[][] stacks;
                IngredientCharset charset = ((IngredientWrapper)ing).getIngredientCharset();
                if (!charset.arePermutationsDistinct() || (stacks = charset.getMatchingStacks()).length <= 1) continue;
                this.permutatingIngredients.put(ing, stacks);
                this.permutations *= stacks.length;
                continue;
            }
            ItemStack[] stacks = ing.func_193365_a();
            if (stacks.length <= 1 || !permutateAll && ((c = ing.getClass()) == Ingredient.class || c == IngredientNBT.class || c == OreIngredient.class)) continue;
            this.permutatingIngredients.put(ing, stacks);
            this.permutations *= stacks.length;
        }
    }

    @Override
    public boolean hasNext() {
        return this.i < this.permutations;
    }

    @Override
    public InventoryCrafting next() {
        ItemStack[] stacks;
        int permPos = this.i;
        HashMap<Ingredient, Object> stackMap = new HashMap<Ingredient, Object>();
        for (Map.Entry<Ingredient, Object> entry : this.permutatingIngredients.entrySet()) {
            stacks = entry.getValue();
            if (stacks instanceof ItemStack[][]) {
                int length = ((ItemStack[][])stacks).length;
                ItemStack[] stackSet = ((ItemStack[][])stacks)[permPos % length];
                if (stackSet.length == 1) {
                    stackMap.put(entry.getKey(), stackSet[0]);
                } else {
                    stackMap.put(entry.getKey(), stackSet);
                }
                permPos /= length;
                continue;
            }
            if (stacks instanceof ItemStack[]) {
                stackMap.put(entry.getKey(), ((ItemStack[])stacks)[permPos % ((ItemStack[])stacks).length]);
                permPos /= stacks.length;
                continue;
            }
            throw new RuntimeException("Unknown stacks type in InventoryCraftingIterator.next(): " + stacks.getClass().getName());
        }
        for (int i = 0; i < this.recipe.input.size(); ++i) {
            Ingredient ing = (Ingredient)this.recipe.input.get(i);
            if (this.permutatingIngredients.containsKey(ing)) {
                Object o = stackMap.get(ing);
                if (o instanceof ItemStack[]) {
                    ItemStack[] stacks2 = (ItemStack[])o;
                    this.func_70299_a(i, stacks2.length > 0 ? stacks2[0] : ItemStack.field_190927_a);
                    this.inputReal[i] = Arrays.asList(stacks2);
                    continue;
                }
                if (o instanceof ItemStack) {
                    this.func_70299_a(i, (ItemStack)o);
                    this.inputReal[i] = stackMap.get(ing);
                    continue;
                }
                throw new RuntimeException("Unknown stacks type in InventoryCraftingIterator.next(): " + o.getClass().getName());
            }
            stacks = ing.func_193365_a();
            this.func_70299_a(i, stacks.length > 0 ? stacks[0] : ItemStack.field_190927_a);
            this.inputReal[i] = ing;
        }
        ++this.i;
        return this;
    }

    public Container contain() {
        return new Container(this);
    }

    public static class Container {
        private final List stacks;
        private final Collection<ItemStack> output;
        private final RecipeCharset base;

        private Container(InventoryCraftingIterator iterator) {
            this.base = iterator.recipe;
            ImmutableList.Builder inputBuilder = ImmutableList.builder();
            for (int i = 0; i < iterator.recipe.input.size(); ++i) {
                inputBuilder.add(iterator.inputReal[i]);
            }
            this.stacks = inputBuilder.build();
            this.output = iterator.permutations == 1 ? iterator.recipe.getAllRecipeOutputs() : Collections.singletonList(iterator.recipe.func_77572_b(iterator));
        }

        public ResourceLocation getRegistryName() {
            return this.base.getRegistryName();
        }

        public List getInputs() {
            return this.stacks;
        }

        public Collection<ItemStack> getOutput() {
            return this.output;
        }

        public boolean isShapeless() {
            return this.base.getType() == RecipeCharset.Type.SHAPELESS;
        }

        public int getWidth() {
            return this.base.getWidth();
        }

        public int getHeight() {
            return this.base.getHeight();
        }
    }
}

