/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gnu.trove.set.TCharSet;
import gnu.trove.set.hash.TCharHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import pl.asie.charset.lib.material.ItemMaterial;
import pl.asie.charset.lib.material.ItemMaterialRegistry;
import pl.asie.charset.lib.recipe.IRecipeResultBuilder;
import pl.asie.charset.lib.recipe.IRecipeView;
import pl.asie.charset.lib.recipe.ingredient.IngredientCharset;
import pl.asie.charset.lib.utils.ItemUtils;

public class IngredientMaterial
extends IngredientCharset {
    private final String[] chain;
    private final TCharSet dependencies;
    private final Collection<String[]> types;
    private final String nbtTag;
    private boolean matchStack;
    private Ingredient dependency;

    protected IngredientMaterial(String nbtTag, Collection<String[]> types) {
        this.types = types;
        this.nbtTag = nbtTag;
        this.chain = null;
        this.dependencies = null;
    }

    protected IngredientMaterial(String nbtTag, String chain, boolean dummy, Collection<String[]> types) {
        this.types = types;
        this.nbtTag = nbtTag;
        this.chain = chain.split("\\.");
        this.dependencies = new TCharHashSet();
        this.dependencies.add(this.chain[0].charAt(0));
    }

    @Override
    public TCharSet getDependencies() {
        return this.dependencies;
    }

    @Override
    public void onAdded(IRecipeView view) {
        if (this.chain != null) {
            char depChar = this.chain[0].charAt(0);
            this.dependency = view.getIngredient(depChar);
        }
    }

    @Override
    public boolean arePermutationsDistinct() {
        return super.arePermutationsDistinct() || this.matchStack || this.chain != null || this.nbtTag != null;
    }

    private ItemMaterial getChainedMaterial(ItemMaterial base) {
        for (int i = 1; i < this.chain.length; ++i) {
            if (this.chain[i].charAt(0) == '?') {
                ItemMaterial nextBase = base.getRelated(this.chain[i].substring(1));
                if (nextBase == null) continue;
                base = nextBase;
                continue;
            }
            if ((base = base.getRelated(this.chain[i])) != null) continue;
            return null;
        }
        return base;
    }

    @Override
    public boolean matches(ItemStack stack, IRecipeResultBuilder builder) {
        if (this.chain != null) {
            ItemStack stackIn = builder.getStack(this.dependency);
            if (!stackIn.func_190926_b()) {
                ItemMaterial base = this.getChainedMaterial(ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(stackIn));
                return base != null && ItemMaterialRegistry.INSTANCE.matches(stack, base);
            }
            return false;
        }
        if (!stack.func_190926_b()) {
            for (String[] typeSet : this.types) {
                if (!ItemMaterialRegistry.INSTANCE.matches(stack, typeSet)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public ItemStack transform(ItemStack stack, ItemStack source, IRecipeResultBuilder builder) {
        if (this.nbtTag != null) {
            ItemUtils.getTagCompound(stack, true).func_74778_a(this.nbtTag, ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(source).getId());
        }
        return stack;
    }

    @Override
    protected ItemStack[][] createMatchingStacks() {
        Collection<Object> mats;
        if (this.chain != null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : this.dependency.func_193365_a()) {
                ItemMaterial materialOut = this.getChainedMaterial(ItemMaterialRegistry.INSTANCE.getOrCreateMaterial(itemStack));
                if (materialOut == null) continue;
                stacks.add(materialOut.getStack());
            }
            ItemStack[][] stackArrays = new ItemStack[stacks.size()][1];
            for (int i = 0; i < stacks.size(); ++i) {
                stackArrays[i][0] = (ItemStack)stacks.get(i);
            }
            return stackArrays;
        }
        if (this.types.size() == 1) {
            mats = ItemMaterialRegistry.INSTANCE.getMaterialsByTypes(this.types.iterator().next());
        } else if (this.types.size() <= 0) {
            mats = Collections.emptyList();
        } else {
            mats = new ArrayList();
            for (String[] t : this.types) {
                mats.addAll(ItemMaterialRegistry.INSTANCE.getMaterialsByTypes(t));
            }
        }
        ItemStack[][] stacks = new ItemStack[mats.size()][1];
        int idx = 0;
        for (ItemMaterial itemMaterial : mats) {
            stacks[idx++][0] = itemMaterial.getStack();
        }
        return stacks;
    }

    @Override
    public boolean hasMatchingStacks() {
        return true;
    }

    public void setRequireMatches(boolean requireMatches) {
        this.matchStack = requireMatches;
    }

    public static class Factory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext jsonContext, JsonObject jsonObject) {
            ImmutableList material;
            String tag = jsonObject.has("nbtKey") ? JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"nbtKey") : null;
            JsonElement oreElem = jsonObject.get("material");
            if (oreElem instanceof JsonArray) {
                ImmutableList.Builder builder = new ImmutableList.Builder();
                ArrayList<String> singleton = new ArrayList<String>();
                JsonArray array = oreElem.getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement arrayElem = array.get(i);
                    if (arrayElem instanceof JsonArray) {
                        JsonArray array2 = (JsonArray)arrayElem;
                        ImmutableList.Builder singleton2 = new ImmutableList.Builder();
                        for (int j = 0; j < array2.size(); ++j) {
                            singleton2.add((Object)array2.get(j).getAsString());
                        }
                        builder.add((Object)singleton2.build().toArray((Object[])new String[0]));
                        continue;
                    }
                    singleton.add(array.get(i).getAsString());
                }
                if (!singleton.isEmpty()) {
                    builder.add((Object)singleton.toArray(new String[0]));
                }
                material = builder.build();
            } else {
                material = Collections.singletonList(new String[]{JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"material")});
            }
            IngredientMaterial result = jsonObject.has("chain") ? new IngredientMaterial(tag, JsonUtils.func_151200_h((JsonObject)jsonObject, (String)"chain"), false, (Collection<String[]>)material) : new IngredientMaterial(tag, (Collection<String[]>)material);
            if (jsonObject.has("matchStack")) {
                result.setRequireMatches(JsonUtils.func_151212_i((JsonObject)jsonObject, (String)"matchStack"));
            }
            return IngredientCharset.wrap(result);
        }
    }
}

