/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.modcompat.jei;

import com.google.common.collect.Lists;
import java.util.Collections;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import pl.asie.charset.lib.modcompat.jei.JEIPluginCharset;
import pl.asie.charset.lib.recipe.InventoryCraftingIterator;

public class JEIRecipeContainer
implements ICraftingRecipeWrapper {
    protected final InventoryCraftingIterator.Container recipe;

    public static JEIRecipeContainer create(InventoryCraftingIterator.Container recipe) {
        return recipe.isShapeless() ? new Shapeless(recipe) : new Shaped(recipe);
    }

    private JEIRecipeContainer(InventoryCraftingIterator.Container recipe) {
        this.recipe = recipe;
    }

    public ResourceLocation getRegistryName() {
        return this.recipe.getRegistryName();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, JEIPluginCharset.STACKS.expandRecipeItemStackInputs(this.recipe.getInputs()));
        ingredients.setOutputLists(ItemStack.class, Collections.singletonList(Lists.newArrayList(this.recipe.getOutput())));
    }

    public static class Shaped
    extends JEIRecipeContainer
    implements IShapedCraftingRecipeWrapper {
        public Shaped(InventoryCraftingIterator.Container recipe) {
            super(recipe);
        }

        public int getWidth() {
            return this.recipe.getWidth();
        }

        public int getHeight() {
            return this.recipe.getHeight();
        }
    }

    public static class Shapeless
    extends JEIRecipeContainer {
        public Shapeless(InventoryCraftingIterator.Container recipe) {
            super(recipe);
        }
    }
}

