/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityProviderFactory<T> {
    private final Capability<T> capability;
    private final Capability.IStorage<T> storage;

    public CapabilityProviderFactory(@Nonnull Capability<T> capability) {
        this(capability, null);
    }

    public CapabilityProviderFactory(@Nonnull Capability<T> capability, @Nullable Capability.IStorage<T> storage) {
        this.capability = capability;
        this.storage = storage;
    }

    public ICapabilityProvider create(T object) {
        return this.storage != null ? new ProviderSerializable(object) : new Provider(object);
    }

    public Capability.IStorage<T> getStorage() {
        return this.storage;
    }

    private class ProviderSerializable
    extends Provider
    implements ICapabilitySerializable<NBTBase> {
        private ProviderSerializable(T object) {
            super(object);
        }

        public NBTBase serializeNBT() {
            return CapabilityProviderFactory.this.storage.writeNBT(CapabilityProviderFactory.this.capability, this.object, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            if (CapabilityProviderFactory.this.storage != null) {
                CapabilityProviderFactory.this.storage.readNBT(CapabilityProviderFactory.this.capability, this.object, null, nbt);
            }
        }
    }

    private class Provider
    implements ICapabilityProvider {
        protected final T object;

        private Provider(T object) {
            this.object = object;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityProviderFactory.this.capability;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CapabilityProviderFactory.this.capability ? CapabilityProviderFactory.this.capability.cast(this.object) : null);
        }
    }
}

