/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.block;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.lib.IAxisRotatable;
import pl.asie.charset.lib.block.ITraitItemAppendable;
import pl.asie.charset.lib.block.Trait;
import pl.asie.charset.lib.block.TraitNameable;
import pl.asie.charset.lib.capability.Capabilities;

public class TileBase
extends TileEntity {
    private Map<String, Trait> traits;
    private int lastComparatorValue = -1;

    public TileBase() {
        if (this.traits == null) {
            this.traits = new LinkedHashMap<String, Trait>();
        }
    }

    public final void registerTrait(String s, Trait t) {
        if (this.traits == null) {
            this.traits = new LinkedHashMap<String, Trait>();
        }
        this.traits.put(s, t);
    }

    protected final boolean updateComparators() {
        int cc = this.getComparatorValue(15);
        if (cc != this.lastComparatorValue) {
            this.field_145850_b.func_175666_e(this.func_174877_v(), this.func_145838_q());
            this.lastComparatorValue = cc;
            return true;
        }
        return false;
    }

    public void onLoad() {
        for (Trait t : this.traits.values()) {
            t.onLoad();
        }
    }

    public void invalidate(InvalidationType type) {
        for (Trait t : this.traits.values()) {
            t.onInvalidate(type);
        }
    }

    public final void func_145843_s() {
        super.func_145843_s();
        this.invalidate(InvalidationType.REMOVAL);
    }

    public final void onChunkUnload() {
        this.invalidate(InvalidationType.UNLOAD);
    }

    public void getDrops(NonNullList<ItemStack> stacks, IBlockState state, int fortune, boolean silkTouch) {
        stacks.add((Object)this.getDroppedBlock(state));
    }

    public ItemStack getPickedBlock(@Nullable EntityPlayer player, @Nullable RayTraceResult result, IBlockState state) {
        return this.getDroppedBlock(state);
    }

    protected ItemStack getDroppedBlock(IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c());
        this.saveToStack(stack);
        return stack;
    }

    protected final ITextComponent getTraitDisplayName(ITextComponent fallback) {
        for (Trait t : this.traits.values()) {
            if (!(t instanceof TraitNameable)) continue;
            return ((TraitNameable)t).getName(fallback);
        }
        return fallback;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.getTraitDisplayName(null);
    }

    public void loadFromStack(ItemStack stack) {
        for (Trait t : this.traits.values()) {
            if (!(t instanceof ITraitItemAppendable)) continue;
            ((ITraitItemAppendable)((Object)t)).loadFromStack(stack);
        }
    }

    public ItemStack saveToStack(ItemStack stack) {
        for (Trait t : this.traits.values()) {
            if (!(t instanceof ITraitItemAppendable)) continue;
            stack = ((ITraitItemAppendable)((Object)t)).saveToStack(stack);
        }
        return stack;
    }

    public void onPlacedBy(EntityLivingBase placer, @Nullable EnumFacing face, ItemStack stack, float hitX, float hitY, float hitZ) {
        this.loadFromStack(stack);
    }

    public int getComparatorValue(int max) {
        return 0;
    }

    public boolean hasDataPacket() {
        return true;
    }

    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        for (Map.Entry<String, Trait> entry : this.traits.entrySet()) {
            if (!compound.func_150297_b(entry.getKey(), 10)) continue;
            entry.getValue().readNBTData(compound.func_74775_l(entry.getKey()), isClient);
        }
    }

    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        for (Map.Entry<String, Trait> entry : this.traits.entrySet()) {
            NBTTagCompound traitCpd = entry.getValue().writeNBTData(isClient);
            if (traitCpd == null) continue;
            compound.func_74782_a(entry.getKey(), (NBTBase)traitCpd);
        }
        return compound;
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        return this.hasDataPacket() ? new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.writeNBTData(new NBTTagCompound(), true)) : null;
    }

    public final NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189515_b(new NBTTagCompound());
        compound = this.writeNBTData(compound, true);
        return compound;
    }

    public final void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt != null && pkt.func_148857_g() != null) {
            this.readNBTData(pkt.func_148857_g(), true);
        }
    }

    public final void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readNBTData(compound, this.field_145850_b != null && this.field_145850_b.field_72995_K);
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        return this.writeNBTData(compound, false);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        for (Trait t : this.traits.values()) {
            if (!t.hasCapability(capability, facing)) continue;
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        for (Trait t : this.traits.values()) {
            if (!t.hasCapability(capability, facing)) continue;
            return t.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected void func_190201_b(World worldIn) {
        this.func_145834_a(worldIn);
    }

    public void func_189667_a(Rotation rotationIn) {
        if (this.hasCapability(Capabilities.AXIS_ROTATABLE, null)) {
            IAxisRotatable rotatable = this.getCapability(Capabilities.AXIS_ROTATABLE, null);
            int count = 0;
            switch (rotationIn) {
                case CLOCKWISE_90: {
                    count = 1;
                    break;
                }
                case CLOCKWISE_180: {
                    count = 2;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    count = 3;
                }
            }
            for (int i = 0; i < count; ++i) {
                rotatable.rotateAround(EnumFacing.UP, false);
            }
        }
    }

    public void update() {
    }

    public boolean canRenderBreaking() {
        return false;
    }

    public TileEntity getNeighbourTile(EnumFacing side) {
        return this.field_145850_b != null && side != null ? this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side)) : null;
    }

    public void markBlockForRenderUpdate() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    public void markBlockForUpdate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public void markChunkDirty() {
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    public static enum InvalidationType {
        REMOVAL,
        UNLOAD;

    }
}

