/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.biome;

import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.libraryex.world.generation.GenerationStage;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitCluster;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitFluid;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitOre;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.entity.monster.EntitySpinout;
import logictechcorp.netherex.init.NetherExBiomes;
import logictechcorp.netherex.init.NetherExBlocks;
import logictechcorp.netherex.world.biome.BiomeNetherEx;
import logictechcorp.netherex.world.generation.trait.BiomeTraitThornstalk;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.world.biome.Biome;

public class BiomeRuthlessSands
extends BiomeNetherEx {
    private static final IBlockState GLOOMY_NETHERRACK = NetherExBlocks.GLOOMY_NETHERRACK.func_176223_P();

    public BiomeRuthlessSands() {
        super(NetherEx.instance, new Biome.BiomeProperties("Ruthless Sands").func_185410_a(2.0f).func_185395_b(0.0f).func_185396_a(), "ruthless_sands");
        this.field_76752_A = SOUL_SAND;
        this.field_76753_B = GLOOMY_NETHERRACK;
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityWitherSkeleton.class, 65, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityPigZombie.class, 45, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntitySpinout.class, 100, 1, 4));
    }

    @Override
    public BiomeData getBiomeData() {
        BiomeData biomeData = new BiomeData((Biome)NetherExBiomes.RUTHLESS_SANDS, 8, true, false);
        biomeData.addBiomeBlock(BiomeData.BlockType.SURFACE_BLOCK, SOUL_SAND);
        biomeData.addBiomeBlock(BiomeData.BlockType.SUBSURFACE_BLOCK, GLOOMY_NETHERRACK);
        biomeData.addBiomeBlock(BiomeData.BlockType.LIQUID_BLOCK, LAVA);
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitFluid.create(trait -> {
            trait.generationAttempts(8);
            trait.generationProbability(1.0);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToSpawn(FLOWING_LAVA);
            trait.blockToTarget(GLOOMY_NETHERRACK);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitCluster.create(trait -> {
            trait.generationAttempts(10);
            trait.randomizeGenerationAttempts(true);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToAttachTo(GLOOMY_NETHERRACK);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitCluster.create(trait -> {
            trait.generationAttempts(10);
            trait.minimumGenerationHeight(1);
            trait.maximumGenerationHeight(128);
            trait.blockToAttachTo(GLOOMY_NETHERRACK);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitFluid.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(118);
            trait.blockToSpawn(FLOWING_LAVA);
            trait.blockToTarget(GLOOMY_NETHERRACK);
            trait.generateFalling(true);
        }));
        biomeData.addBiomeTrait(GenerationStage.PLANT_DECORATION, (BiomeTrait)BiomeTraitThornstalk.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(32);
            trait.maximumGenerationHeight(108);
        }));
        biomeData.addBiomeTrait(GenerationStage.ORE, (BiomeTrait)BiomeTraitOre.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(NetherExBlocks.QUARTZ_ORE.func_176223_P());
            trait.blockToReplace(GLOOMY_NETHERRACK);
            trait.veinSize(14);
        }));
        return biomeData;
    }
}

