/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.world.biome;

import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.libraryex.world.generation.GenerationStage;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitCluster;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitOre;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitPool;
import logictechcorp.libraryex.world.generation.trait.BiomeTraitScatter;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.entity.monster.EntityBrute;
import logictechcorp.netherex.entity.monster.EntityCoolmarSpider;
import logictechcorp.netherex.entity.monster.EntityFrost;
import logictechcorp.netherex.entity.monster.EntityWight;
import logictechcorp.netherex.init.NetherExBiomes;
import logictechcorp.netherex.init.NetherExBlocks;
import logictechcorp.netherex.world.biome.BiomeNetherEx;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.biome.Biome;

public class BiomeArcticAbyss
extends BiomeNetherEx {
    private static final IBlockState FROSTBURN_ICE = NetherExBlocks.FROSTBURN_ICE.func_176223_P();
    private static final IBlockState ICY_NETHERRACK = NetherExBlocks.ICY_NETHERRACK.func_176223_P();

    public BiomeArcticAbyss() {
        super(NetherEx.instance, new Biome.BiomeProperties("Arctic Abyss").func_185410_a(0.0f).func_185395_b(0.0f).func_185396_a(), "arctic_abyss");
        this.field_76752_A = FROSTBURN_ICE;
        this.field_76753_B = ICY_NETHERRACK;
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityFrost.class, 10, 1, 3));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityCoolmarSpider.class, 35, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityWight.class, 100, 1, 4));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityBrute.class, 15, 1, 1));
    }

    @Override
    public BiomeData getBiomeData() {
        BiomeData biomeData = new BiomeData((Biome)NetherExBiomes.ARCTIC_ABYSS, 2, true, false);
        biomeData.addBiomeBlock(BiomeData.BlockType.SURFACE_BLOCK, FROSTBURN_ICE);
        biomeData.addBiomeBlock(BiomeData.BlockType.SUBSURFACE_BLOCK, ICY_NETHERRACK);
        biomeData.addBiomeBlock(BiomeData.BlockType.LIQUID_BLOCK, MAGMA);
        biomeData.addBiomeTrait(GenerationStage.TERRAIN_ALTERATION, (BiomeTrait)BiomeTraitPool.create(trait -> {
            trait.generationAttempts(2);
            trait.generationProbability(0.125);
            trait.minimumGenerationHeight(36);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(NetherExBlocks.ICHOR.func_176223_P());
            trait.blockToSurround(FROSTBURN_ICE);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitScatter.create(trait -> {
            trait.generationAttempts(5);
            trait.randomizeGenerationAttempts(true);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToSpawn(NetherExBlocks.BLUE_FIRE.func_176223_P());
            trait.blockToTarget(FROSTBURN_ICE);
            trait.placement(BiomeTraitScatter.Placement.ON_GROUND);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitCluster.create(trait -> {
            trait.generationAttempts(10);
            trait.randomizeGenerationAttempts(true);
            trait.minimumGenerationHeight(4);
            trait.maximumGenerationHeight(124);
            trait.blockToAttachTo(ICY_NETHERRACK);
            trait.direction(EnumFacing.DOWN);
        }));
        biomeData.addBiomeTrait(GenerationStage.DECORATION, (BiomeTrait)BiomeTraitCluster.create(trait -> {
            trait.generationAttempts(10);
            trait.minimumGenerationHeight(1);
            trait.maximumGenerationHeight(128);
            trait.blockToAttachTo(ICY_NETHERRACK);
            trait.direction(EnumFacing.DOWN);
        }));
        biomeData.addBiomeTrait(GenerationStage.ORE, (BiomeTrait)BiomeTraitOre.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(NetherExBlocks.QUARTZ_ORE.func_176223_P());
            trait.blockToReplace(ICY_NETHERRACK);
            trait.veinSize(14);
        }));
        biomeData.addBiomeTrait(GenerationStage.ORE, (BiomeTrait)BiomeTraitOre.create(trait -> {
            trait.generationAttempts(16);
            trait.minimumGenerationHeight(10);
            trait.maximumGenerationHeight(108);
            trait.blockToSpawn(NetherExBlocks.RIME_ORE.func_176223_P());
            trait.blockToReplace(ICY_NETHERRACK);
            trait.veinSize(7);
        }));
        return biomeData;
    }
}

