/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.handler;

import java.util.Random;
import logictechcorp.libraryex.utility.RandomHelper;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.libraryex.world.generation.GenerationStage;
import logictechcorp.libraryex.world.generation.trait.BiomeTrait;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.handler.ConfigHandler;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="netherex")
public class BiomeTraitGenerationHandler {
    @SubscribeEvent
    public static void onPreBiomeDecorate(DecorateBiomeEvent.Pre event) {
        World world = event.getWorld();
        if (world.field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
            BiomeTraitGenerationHandler.generateBiomeTraits(event.getWorld(), event.getChunkPos().func_180331_a(0, 0, 0), event.getRand(), GenerationStage.TERRAIN_ALTERATION);
        }
    }

    @SubscribeEvent
    public static void onBiomeDecorate(DecorateBiomeEvent.Decorate event) {
        World world = event.getWorld();
        if (world.field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a() && event.getType() == DecorateBiomeEvent.Decorate.EventType.CUSTOM) {
            BiomeTraitGenerationHandler.generateBiomeTraits(event.getWorld(), event.getChunkPos().func_180331_a(0, 0, 0), event.getRand(), GenerationStage.DECORATION);
            BiomeTraitGenerationHandler.generateBiomeTraits(event.getWorld(), event.getChunkPos().func_180331_a(0, 0, 0), event.getRand(), GenerationStage.PLANT_DECORATION);
        }
    }

    @SubscribeEvent
    public static void onPostBiomeDecorate(DecorateBiomeEvent.Post event) {
        World world = event.getWorld();
        if (world.field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a()) {
            BiomeTraitGenerationHandler.generateBiomeTraits(event.getWorld(), event.getChunkPos().func_180331_a(0, 0, 0), event.getRand(), GenerationStage.STRUCTURE);
        }
    }

    @SubscribeEvent
    public static void onGenerateOres(OreGenEvent.GenerateMinable event) {
        World world = event.getWorld();
        if (world.field_73011_w.getDimension() == DimensionType.NETHER.func_186068_a() && event.getType() == OreGenEvent.GenerateMinable.EventType.CUSTOM) {
            BiomeTraitGenerationHandler.generateBiomeTraits(event.getWorld(), event.getPos(), event.getRand(), GenerationStage.ORE);
        }
    }

    private static void generateBiomeTraits(World world, BlockPos pos, Random random, GenerationStage generationStage) {
        BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData(world.func_180494_b(pos.func_177982_a(16, 0, 16)));
        if (ConfigHandler.dimensionConfig.nether.overrideNether && biomeData != BiomeData.EMPTY) {
            for (BiomeTrait trait : biomeData.getBiomeTraits(generationStage)) {
                for (int generationAttempts = 0; generationAttempts < trait.getGenerationAttempts(world, pos, random); ++generationAttempts) {
                    trait.generate(world, pos.func_177982_a(random.nextInt(16) + 8, RandomHelper.getNumberInRange((int)trait.getMinimumGenerationHeight(world, pos, random), (int)trait.getMaximumGenerationHeight(world, pos, random), (Random)random), random.nextInt(16) + 8), random);
                }
            }
        }
    }
}

