/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.entity.ai;

import java.util.UUID;
import logictechcorp.libraryex.utility.EntityHelper;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityAIFollowOwnerRideable
extends EntityAIBase {
    private final AbstractHorse rideable;
    private EntityLivingBase owner;
    private final World world;
    private final double followSpeed;
    private final PathNavigate navigator;
    private int timeToRecalculatePath;
    private float maxDistance;
    private float minDistance;
    private float oldWaterCost;

    public EntityAIFollowOwnerRideable(AbstractHorse rideable, double followSpeed, float minDistance, float maxDistance) {
        this.rideable = rideable;
        this.world = rideable.field_70170_p;
        this.followSpeed = followSpeed;
        this.navigator = rideable.func_70661_as();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.func_75248_a(3);
        if (!(rideable.func_70661_as() instanceof PathNavigateGround || rideable.func_70661_as() instanceof PathNavigateFlying || rideable.func_70661_as() instanceof PathNavigateClimber)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        Entity entity = EntityHelper.getFromUUID((MinecraftServer)this.rideable.func_184102_h(), (UUID)this.rideable.func_184780_dh());
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) {
            return false;
        }
        if (this.rideable.func_70068_e(entity) < (double)(this.minDistance * this.minDistance)) {
            return false;
        }
        this.owner = (EntityLivingBase)entity;
        return true;
    }

    public boolean func_75253_b() {
        return !this.navigator.func_75500_f() && this.rideable.func_70068_e((Entity)this.owner) > (double)(this.maxDistance * this.maxDistance);
    }

    public void func_75249_e() {
        this.timeToRecalculatePath = 0;
        this.oldWaterCost = this.rideable.func_184643_a(PathNodeType.WATER);
        this.rideable.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.rideable.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.rideable.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.rideable.func_70646_bf());
        if (this.timeToRecalculatePath-- <= 0) {
            this.timeToRecalculatePath = 10;
            if (!this.navigator.func_75497_a((Entity)this.owner, this.followSpeed) && !this.rideable.func_110167_bD() && !this.rideable.func_184218_aH() && this.rideable.func_70068_e((Entity)this.owner) >= 144.0) {
                int posX = MathHelper.func_76128_c((double)this.owner.field_70165_t) - 2;
                int posZ = MathHelper.func_76128_c((double)this.owner.field_70161_v) - 2;
                int posY = MathHelper.func_76128_c((double)this.owner.func_174813_aQ().field_72338_b);
                for (int x = 0; x <= 4; ++x) {
                    for (int z = 0; z <= 4; ++z) {
                        if (x >= 1 && z >= 1 && x <= 3 && z <= 3 || !this.isTeleportFriendlyBlock(posX, posZ, posY, x, z)) continue;
                        this.rideable.func_70012_b((double)((float)(posX + x) + 0.5f), (double)posY, (double)((float)(posZ + z) + 0.5f), this.rideable.field_70177_z, this.rideable.field_70125_A);
                        this.navigator.func_75499_g();
                        return;
                    }
                }
            }
        }
    }

    protected boolean isTeleportFriendlyBlock(int x, int z, int y, int xOffset, int zOffset) {
        BlockPos pos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        IBlockState state = this.world.func_180495_p(pos);
        return state.func_193401_d((IBlockAccess)this.world, pos, EnumFacing.DOWN) == BlockFaceShape.SOLID && state.func_189884_a((Entity)this.rideable) && this.world.func_175623_d(pos.func_177984_a()) && this.world.func_175623_d(pos.func_177981_b(2));
    }
}

