/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.mod;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import subaraki.paintings.config.ConfigurationHandler;
import subaraki.paintings.mod.IPaintingsProxy;
import subaraki.paintings.mod.LoginHandler;
import subaraki.paintings.mod.PaintingsPattern;
import subaraki.paintings.mod.entity.EntityHandler;
import subaraki.paintings.mod.network.NetworkHandler;

@Mod(modid="morepaintings", name="Paintings++", version="$version", dependencies="after:paintingselgui", acceptedMinecraftVersions="[1.12.2]")
public class Paintings {
    public static final String MODID = "morepaintings";
    public static final String RESOURCE_DOMAIN = "subaraki";
    public static final String VERSION = "$version";
    public static final String NAME = "Paintings++";
    public static final String[] AUTHORS = new String[]{"Subaraki", "MurphysChaos"};
    @SidedProxy(serverSide="subaraki.paintings.mod.server.proxy.ServerProxy", clientSide="subaraki.paintings.mod.client.proxy.ClientProxy")
    public static IPaintingsProxy proxy;
    public static Logger log;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        ModMetadata modMeta = event.getModMetadata();
        modMeta.authorList = Arrays.asList(AUTHORS);
        modMeta.autogenerated = false;
        modMeta.credits = "Subaraki";
        modMeta.description = "More Paintings! Check the config file for options.";
        modMeta.url = "http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/1287285-/";
        ConfigurationHandler.instance.loadConfig(event.getSuggestedConfigurationFile());
        new EntityHandler();
        Paintings.loadPattern();
        proxy.registerRenderInformation();
        new NetworkHandler();
        new LoginHandler();
    }

    public static void loadPattern() {
        JsonObject patternObject = proxy.getPatternFile(ConfigurationHandler.instance.texture);
        PaintingsPattern.instance = (PaintingsPattern)new Gson().fromJson((JsonElement)patternObject, PaintingsPattern.class);
        try {
            PaintingsPattern.instance.parsePattern();
            proxy.configurePaintingsGuiButtonTexture();
        }
        catch (Exception e) {
            log.warn(e.getLocalizedMessage());
        }
    }
}

