/*
 * Decompiled with CFR 0.152.
 */
package com.mcf.davidee.paintinggui.packet;

import com.mcf.davidee.paintinggui.mod.PaintingSelection;
import com.mcf.davidee.paintinggui.wrapper.PaintingWrapper;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import subaraki.paintings.mod.entity.EntityNewPainting;

public class CPacketPainting
implements IMessage {
    public int id;
    public String[] art;
    public EnumFacing face;

    public CPacketPainting() {
    }

    public CPacketPainting(EntityNewPainting painting, String[] data) {
        this.id = painting.func_145782_y();
        this.art = data;
        this.face = painting.field_174860_b;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.art.length);
        for (int i = 0; i < this.art.length; ++i) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.art[i]);
        }
        buf.writeByte(this.face.func_176736_b());
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        String[] s = new String[buf.readInt()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        this.art = s;
        this.face = EnumFacing.func_176731_b((int)buf.readByte());
    }

    public static class CPaintingMessageHandler
    implements IMessageHandler<CPacketPainting, IMessage> {
        public IMessage onMessage(CPacketPainting message, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(() -> {
                if (message.id == -1) {
                    PaintingSelection.proxy.processRayTracing();
                } else if (message.art.length == 1) {
                    PaintingWrapper wrapper = this.getPaintingWrapper(message.art[0]);
                    Entity e = mc.field_71441_e.func_73045_a(message.id);
                    if (e instanceof EntityNewPainting) {
                        EntityNewPainting painting = (EntityNewPainting)e;
                        painting.field_174860_b = message.face;
                        this.setPaintingArt(painting, wrapper);
                    }
                } else {
                    PaintingSelection.proxy.displayPaintingSelectionScreen(message);
                }
            });
            return null;
        }

        protected PaintingWrapper getPaintingWrapper(String artName) {
            if (PaintingWrapper.PAINTINGS.containsKey(artName)) {
                return PaintingWrapper.PAINTINGS.get(artName);
            }
            return PaintingWrapper.createDefault(artName);
        }

        protected void setPaintingArt(EntityNewPainting p, PaintingWrapper art) {
            NBTTagCompound tag = new NBTTagCompound();
            p.func_70014_b(tag);
            tag.func_74778_a("Motive", art.getTitle());
            p.func_70037_a(tag);
        }
    }
}

