/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.service;

import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.ServiceNotAvailableError;

public final class MixinService {
    private static MixinService instance;
    private ServiceLoader<IMixinService> serviceLoader;
    private IMixinService service = null;

    private MixinService() {
    }

    private static MixinService getCanonicalInstance() {
        if (instance == null) {
            instance = new MixinService();
        }
        return instance;
    }

    public static IMixinService getService() {
        return MixinService.getCanonicalInstance().getServiceInstance();
    }

    private synchronized IMixinService getServiceInstance() {
        if (this.service == null) {
            this.service = this.initService();
            if (this.service == null) {
                throw new ServiceNotAvailableError("No mixin host service is available");
            }
        }
        return this.service;
    }

    private IMixinService initService() {
        this.serviceLoader = ServiceLoader.load(IMixinService.class, this.getClass().getClassLoader());
        Iterator<IMixinService> iter = this.serviceLoader.iterator();
        while (iter.hasNext()) {
            try {
                IMixinService service = iter.next();
                if (!service.isValid()) continue;
                return service;
            }
            catch (ServiceConfigurationError serviceError) {
                serviceError.printStackTrace();
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
        return null;
    }
}

