/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.movingworld.common.network.message;

import com.elytradev.movingworld.common.entity.EntityMovingWorld;
import com.elytradev.movingworld.common.network.MovingWorldNetworking;
import com.elytradev.movingworld.common.network.message.MovingWorldTileChangeMessage;
import com.elytradev.movingworld.common.tile.TileMovingMarkingBlock;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.Message;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.NetworkContext;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.annotation.field.MarshalledAs;
import com.elytradev.movingworld.repackage.com.elytradev.concrete.network.annotation.type.ReceivedOn;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;

@ReceivedOn(value=Side.SERVER)
public class MovingWorldDataRequestMessage
extends Message {
    @MarshalledAs(value="com.elytradev.movingworld.common.network.marshallers.EntityMarshaller")
    public EntityMovingWorld movingWorld;

    public MovingWorldDataRequestMessage(NetworkContext ctx) {
        super(ctx);
    }

    public MovingWorldDataRequestMessage(EntityMovingWorld movingWorld) {
        super(MovingWorldNetworking.NETWORK);
        this.movingWorld = movingWorld;
    }

    @Override
    protected void handle(EntityPlayer sender) {
        if (this.movingWorld == null) {
            return;
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (TileEntity te : this.movingWorld.getMobileChunk().chunkTileEntityMap.values()) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (te instanceof TileMovingMarkingBlock) {
                ((TileMovingMarkingBlock)te).writeNBTForSending(nbt);
            } else {
                te.func_189515_b(nbt);
            }
            list.func_74742_a((NBTBase)nbt);
        }
        tagCompound.func_74782_a("list", (NBTBase)list);
        new MovingWorldTileChangeMessage(this.movingWorld, tagCompound).sendTo(sender);
    }
}

