/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.util;

import java.util.function.BiPredicate;
import net.minecraft.block.BlockChest;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class UtilScanner {
    public static BlockPos findBlock(EntityLiving entity, int scanRange, int yVariance, int tries, BiPredicate<World, BlockPos> predicate) {
        int scanSize = scanRange;
        int adjustRangeY = 10;
        int tryY = MathHelper.func_76128_c((double)entity.field_70163_u);
        for (int ii = 0; ii <= tries; ++ii) {
            int tryMax;
            scanSize = ii <= 3 ? 20 : scanRange;
            int tryX = MathHelper.func_76128_c((double)entity.field_70165_t) + (entity.field_70170_p.field_73012_v.nextInt(scanSize) - scanSize / 2);
            int i = tryY + (yVariance > 0 ? entity.field_70170_p.field_73012_v.nextInt(yVariance) - entity.field_70170_p.field_73012_v.nextInt(yVariance) : 0);
            int tryZ = MathHelper.func_76128_c((double)entity.field_70161_v) + (entity.field_70170_p.field_73012_v.nextInt(scanSize) - scanSize / 2);
            BlockPos posTry = new BlockPos(tryX, tryY, tryZ);
            boolean foundBlock = false;
            int newY = i;
            if (!entity.field_70170_p.func_175623_d(posTry)) {
                tryMax = adjustRangeY;
                while (!entity.field_70170_p.func_175623_d(posTry) && tryMax-- > 0) {
                    posTry = new BlockPos(tryX, ++newY, tryZ);
                }
                if (entity.field_70170_p.func_175623_d(posTry) && predicate.test(entity.field_70170_p, posTry.func_177982_a(0, -1, 0))) {
                    foundBlock = true;
                    posTry = posTry.func_177982_a(0, -1, 0);
                }
            } else {
                tryMax = adjustRangeY;
                while (entity.field_70170_p.func_175623_d(posTry) && tryMax-- > 0) {
                    posTry = new BlockPos(tryX, --newY, tryZ);
                }
                if (entity.field_70170_p.func_175623_d(posTry.func_177982_a(0, 1, 0)) && predicate.test(entity.field_70170_p, posTry)) {
                    foundBlock = true;
                }
            }
            if (!foundBlock) continue;
            return posTry;
        }
        return null;
    }

    public static boolean isWater(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a().func_76224_d();
    }

    public static boolean isDeepWater(World world, BlockPos pos) {
        boolean clearAbove = world.func_175623_d(pos.func_177981_b(1)) && world.func_175623_d(pos.func_177981_b(2)) && world.func_175623_d(pos.func_177981_b(3));
        boolean deep = world.func_180495_p(pos).func_185904_a().func_76224_d() && world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76224_d();
        boolean notUnderground = false;
        if (deep) {
            int height = world.func_175725_q(pos).func_177956_o() - 1;
            notUnderground = height == pos.func_177956_o();
        }
        return deep && notUnderground && clearAbove;
    }

    public static boolean isLand(World world, BlockPos pos) {
        return world.func_180495_p(pos).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP);
    }

    public static boolean isFire(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_185904_a() == Material.field_151581_o;
    }

    public static boolean isChest(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockChest;
    }
}

