/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity;

import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilEntity;
import com.corosus.zombie_players.Zombie_Players;
import com.corosus.zombie_players.config.ConfigZombiePlayers;
import com.corosus.zombie_players.config.ConfigZombiePlayersAdvanced;
import com.corosus.zombie_players.entity.ai.EntityAIAvoidEntityOnLowHealth;
import com.corosus.zombie_players.entity.ai.EntityAIEatToHeal;
import com.corosus.zombie_players.entity.ai.EntityAIFollowOwnerZombie;
import com.corosus.zombie_players.entity.ai.EntityAIInteractChest;
import com.corosus.zombie_players.entity.ai.EntityAIMoveToWantedNearbyItems;
import com.corosus.zombie_players.entity.ai.EntityAIMoveTowardsRestrictionZombie;
import com.corosus.zombie_players.entity.ai.EntityAINearestAttackableTargetIfCalm;
import com.corosus.zombie_players.entity.ai.EntityAIPlayZombiePlayer;
import com.corosus.zombie_players.entity.ai.EntityAITemptZombie;
import com.corosus.zombie_players.entity.ai.EntityAIZombieAttackWeaponReach;
import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import com.mojang.util.UUIDTypeAdapter;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityZombiePlayer
extends EntityZombie
implements IEntityAdditionalSpawnData,
IEntityOwnable {
    public static Predicate<EntityLivingBase> ENEMY_PREDICATE = p_apply_1_ -> p_apply_1_ != null && IMob.field_175450_e.apply(p_apply_1_) && !(p_apply_1_ instanceof EntityCreeper) && (!(p_apply_1_ instanceof EntityZombiePlayer) || p_apply_1_ instanceof EntityZombiePlayer && ((EntityZombiePlayer)p_apply_1_).calmTime == 0 && ((EntityZombiePlayer)((Object)p_apply_1_)).func_70638_az() != null);
    public boolean spawnedFromPlayerDeath = false;
    public GameProfile gameProfile;
    public int risingTime = -20;
    public int risingTimeMax = 40;
    public boolean quiet = false;
    public boolean canEatFromChests = false;
    public boolean shouldFollowOwner = false;
    private boolean isPlaying;
    private int calmTime = 0;
    public List<BlockPos> listPosChests = new ArrayList<BlockPos>();
    public static int MAX_CHESTS = 4;
    public String ownerName = "";
    public WeakReference<EntityPlayer> playerWeakReference = new WeakReference<Object>(null);
    public boolean hasOpenedChest = false;
    public BlockPos posChestUsing = null;
    public int chestUseTime = 0;
    public BlockPos homePositionBackup = null;
    public int homeDistBackup = -1;
    public long lastTimeStartedPlaying = 0L;

    public static EntityZombiePlayer spawnInPlaceOfPlayer(EntityPlayerMP player) {
        boolean spawn = true;
        EntityZombiePlayer zombie = null;
        if (player.func_180470_cg() != null && player.func_180470_cg().func_185332_f(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v)) < (double)ConfigZombiePlayers.distanceFromPlayerSpawnPointToPreventZombieSpawn) {
            spawn = false;
        }
        if (spawn) {
            zombie = EntityZombiePlayer.spawnInPlaceOfPlayer(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, player.func_146103_bH());
            if (player.func_180470_cg() != null) {
                zombie.setHomePosAndDistance(player.func_180470_cg(), 16, true);
            }
        }
        return zombie;
    }

    public static EntityZombiePlayer spawnInPlaceOfPlayer(World world, double x, double y, double z, GameProfile profile) {
        EntityZombiePlayer zombie = new EntityZombiePlayer(world);
        zombie.func_70107_b(x, y, z);
        zombie.setGameProfile(profile);
        zombie.func_180482_a(world.func_175649_E(new BlockPos(x, y, z)), null);
        zombie.func_110163_bv();
        zombie.spawnedFromPlayerDeath = true;
        world.func_72838_d((Entity)zombie);
        return zombie;
    }

    public EntityZombiePlayer(World worldIn) {
        super(worldIn);
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(ConfigZombiePlayers.opensDoors);
    }

    protected void func_184651_r() {
        int taskID = 0;
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(taskID++, new EntityAIAvoidEntityOnLowHealth<EntityLivingBase>((EntityCreature)this, EntityLivingBase.class, ENEMY_PREDICATE, 16.0f, 1.4, 1.4, 10.0f));
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAIEatToHeal(this));
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAIZombieAttackWeaponReach(this, 1.0, false));
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAIMoveToWantedNearbyItems(this, 1.15));
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, false));
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAIFollowOwnerZombie(this, 1.2, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAIMoveTowardsRestrictionZombie(this, 1.0){});
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAITemptZombie((EntityCreature)this, 1.2, false));
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAIInteractChest(this, 1.0, 20));
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAIPlayZombiePlayer(this, 1.15));
        this.field_70714_bg.func_75776_a(taskID++, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(taskID, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(taskID, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityZombiePlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(taskID, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableTargetIfCalm<EntityPlayer>(this, EntityPlayer.class, true, true));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTargetIfCalm<EntityVillager>(this, EntityVillager.class, false, true));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTargetIfCalm<EntityIronGolem>(this, EntityIronGolem.class, true, true));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTargetIfCalm<EntityLivingBase>(this, EntityLiving.class, 0, true, false, ENEMY_PREDICATE, false));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.risingTime < this.risingTimeMax) {
            ++this.risingTime;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.calmTime > 0) {
                if (this.chestUseTime > 0) {
                    --this.chestUseTime;
                    if (this.chestUseTime == 0 && this.posChestUsing != null) {
                        this.closeChest(this.posChestUsing);
                    }
                }
                if (this.calmTime <= 100 && this.calmTime % 10 == 0) {
                    this.func_184185_a(SoundEvents.field_187945_hs, this.func_70599_aP(), this.func_70647_i());
                    ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.VILLAGER_ANGRY, true, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, 1, 0.3, 0.0, 0.3, 1.0, new int[]{0});
                } else if (this.calmTime <= 1800 && this.calmTime % 100 == 0) {
                    this.func_184185_a(SoundEvents.field_187940_hn, this.func_70599_aP(), this.func_70647_i());
                    ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.VILLAGER_ANGRY, true, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, 1, 0.3, 0.0, 0.3, 1.0, new int[]{0});
                }
                if (this.isHealthLow()) {
                    ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.REDSTONE, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, 1, 0.1, 0.0, 0.1, 0.0, new int[]{0});
                }
                if (this.isCalmTimeLow()) {
                    ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.SPELL, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, 1, 0.1, 0.0, 0.1, 0.0, new int[]{0});
                }
                --this.calmTime;
                if (this.calmTime == 0) {
                    this.onBecomeHostile();
                }
            }
            if ((double)this.field_70170_p.func_82737_E() % ConfigZombiePlayersAdvanced.heal1HealthPerXTicks == 0.0) {
                this.func_70691_i(1.0f);
            }
            if (this.isFoodNeedUrgent() || !ConfigZombiePlayersAdvanced.onlySeekFoodIfNeeded && this.field_70170_p.func_82737_E() % 20L == 0L) {
                for (EntityItem entityitem : this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0))) {
                    if (entityitem.field_70128_L || entityitem.func_92059_d().func_190926_b() || entityitem.func_174874_s() || !this.isItemWeWant(entityitem.func_92059_d())) continue;
                    this.func_71001_a((Entity)entityitem, entityitem.func_92059_d().func_190916_E());
                    entityitem.func_70106_y();
                    this.ateCalmingItem();
                    break;
                }
            }
            if (this.field_70170_p.func_82737_E() % 20L == 0L && this.isItemWeWant(this.func_184614_ca())) {
                for (int i = 0; i < this.func_184614_ca().func_190916_E(); ++i) {
                    if (i == 0) {
                        this.ateCalmingItem(true);
                        continue;
                    }
                    this.ateCalmingItem(false);
                }
                this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            }
        }
        if (this.risingTime < this.risingTimeMax) {
            this.func_94061_f(true);
            if (this.field_70170_p.field_72995_K) {
                IBlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
                double speed = 0.2;
                for (int i = 0; i < 5; ++i) {
                    double x1 = this.field_70170_p.field_73012_v.nextDouble() - this.field_70170_p.field_73012_v.nextDouble();
                    double z1 = this.field_70170_p.field_73012_v.nextDouble() - this.field_70170_p.field_73012_v.nextDouble();
                    double x2 = (this.field_70170_p.field_73012_v.nextDouble() - this.field_70170_p.field_73012_v.nextDouble()) * speed;
                    double y2 = (this.field_70170_p.field_73012_v.nextDouble() - this.field_70170_p.field_73012_v.nextDouble()) * speed;
                    double z2 = (this.field_70170_p.field_73012_v.nextDouble() - this.field_70170_p.field_73012_v.nextDouble()) * speed;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t + x1, this.field_70163_u, this.field_70161_v + z1, x2, y2, z2, new int[]{Block.func_176210_f((IBlockState)state)});
                }
            }
        } else {
            this.func_94061_f(false);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.isCalm() && this.isCanEatFromChests()) {
            this.tickScanForChests();
        }
    }

    public void onBecomeCalm() {
        this.setCanEquip(ConfigZombiePlayers.pickupLootWhenCalm);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public void onBecomeHostile() {
        this.setCanEquip(ConfigZombiePlayers.pickupLootWhenHostile);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
    }

    public boolean isItemWeWant(ItemStack stack) {
        return this.isRawMeat(stack);
    }

    public void ateCalmingItem() {
        this.ateCalmingItem(true);
    }

    public void ateCalmingItem(boolean effect) {
        EntityPlayer player;
        if (!this.isCalm()) {
            this.onBecomeCalm();
        }
        if (!this.hasOwner() && (player = this.field_70170_p.func_72890_a((Entity)this, 16.0)) != null) {
            this.setOwnerName(player.func_70005_c_());
        }
        this.calmTime += ConfigZombiePlayersAdvanced.calmTimePerUse;
        this.func_70624_b(null);
        this.func_70604_c(null);
        this.func_70691_i((float)ConfigZombiePlayersAdvanced.healPerUse);
        if (effect) {
            ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.HEART, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, 1, 0.3, 0.0, 0.3, 1.0, new int[]{0});
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        if (this.calmTime > 0 && entitylivingbaseIn instanceof EntityPlayer) {
            super.func_70624_b(null);
            this.func_70661_as().func_75499_g();
        } else if (this.calmTime <= 0 || !(entitylivingbaseIn instanceof EntityZombiePlayer) || ((EntityZombiePlayer)entitylivingbaseIn).calmTime <= 0) {
            super.func_70624_b(entitylivingbaseIn);
        }
    }

    public boolean isCalm() {
        return this.calmTime > 0;
    }

    public boolean isRawMeat(ItemStack stack) {
        Item item = stack.func_77973_b();
        return Zombie_Players.listCalmingItems.contains(item);
    }

    public void func_70642_aH() {
        SoundEvent soundevent;
        if (!this.quiet && (soundevent = this.func_184639_G()) != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && player != null && hand == EnumHand.MAIN_HAND) {
            ItemStack itemstack = player.func_184586_b(hand);
            boolean itemUsed = false;
            int particleCount = 5;
            EnumParticleTypes particle = null;
            if (this.isCalm() && itemstack.func_77973_b() == Items.field_151034_e) {
                itemUsed = true;
                this.quiet = !this.quiet;
                particle = EnumParticleTypes.NOTE;
            } else if (this.isCalm() && itemstack.func_77973_b() == Items.field_151069_bo) {
                itemUsed = true;
                this.func_82227_f(!this.func_70631_g_());
                particle = EnumParticleTypes.SPELL_MOB;
            } else if (this.isCalm() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150486_ae)) {
                this.setCanEatFromChests(!this.canEatFromChests);
                particle = this.canEatFromChests ? EnumParticleTypes.HEART : EnumParticleTypes.SPELL_MOB;
            } else if (this.isCalm() && itemstack.func_77973_b() == Items.field_151078_bh) {
                itemUsed = true;
                this.func_82160_b(true, 0);
                this.clearInventory();
                particle = EnumParticleTypes.SPELL_WITCH;
            } else if (itemstack.func_77973_b() == Items.field_151104_aV) {
                if (this.isCalm()) {
                    particle = null;
                    if (this.func_110167_bD()) {
                        ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.REDSTONE, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, particleCount, 0.3, 0.0, 0.3, 1.0, new int[]{0});
                        player.func_145747_a((ITextComponent)new TextComponentString("Can't set home while leashed"));
                    } else if (this.func_110175_bO()) {
                        if (this.func_110174_bM() == ConfigZombiePlayersAdvanced.stayNearHome_range1) {
                            ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.HEART, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 1.0, this.field_70161_v, particleCount, 0.3, 0.0, 0.3, 1.0, new int[]{0});
                            this.setHomePosAndDistance(this.func_180425_c(), (int)ConfigZombiePlayersAdvanced.stayNearHome_range2, true);
                            player.func_145747_a((ITextComponent)new TextComponentString("Home set with max wander distance of " + ConfigZombiePlayersAdvanced.stayNearHome_range2));
                        } else if (this.func_110174_bM() == ConfigZombiePlayersAdvanced.stayNearHome_range2) {
                            ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.HEART, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 1.5, this.field_70161_v, particleCount, 0.3, 0.0, 0.3, 1.0, new int[]{0});
                            this.setHomePosAndDistance(this.func_180425_c(), (int)ConfigZombiePlayersAdvanced.stayNearHome_range3, true);
                            player.func_145747_a((ITextComponent)new TextComponentString("Home set with max wander distance of " + ConfigZombiePlayersAdvanced.stayNearHome_range3));
                        } else if (this.func_110174_bM() == ConfigZombiePlayersAdvanced.stayNearHome_range3) {
                            ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.REDSTONE, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, particleCount, 0.3, 0.0, 0.3, 1.0, new int[]{0});
                            this.setHomePosAndDistance(BlockPos.field_177992_a, -1, true);
                            player.func_145747_a((ITextComponent)new TextComponentString("Home removed"));
                        } else {
                            ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.HEART, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, particleCount, 0.3, 0.0, 0.3, 1.0, new int[]{0});
                            this.setHomePosAndDistance(this.func_180425_c(), (int)ConfigZombiePlayersAdvanced.stayNearHome_range1, true);
                            player.func_145747_a((ITextComponent)new TextComponentString("Home set with max wander distance of " + ConfigZombiePlayersAdvanced.stayNearHome_range1));
                        }
                    } else {
                        ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.HEART, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, particleCount, 0.3, 0.0, 0.3, 1.0, new int[]{0});
                        this.setHomePosAndDistance(this.func_180425_c(), (int)ConfigZombiePlayersAdvanced.stayNearHome_range1, true);
                        player.func_145747_a((ITextComponent)new TextComponentString("Home set with max wander distance of " + ConfigZombiePlayersAdvanced.stayNearHome_range1));
                    }
                }
            } else if (this.isRawMeat(itemstack)) {
                itemUsed = true;
                if (!this.hasOwner()) {
                    this.setOwnerName(player.func_70005_c_());
                }
                this.ateCalmingItem();
                particle = null;
            } else if (this.isCalm() && itemstack.func_190926_b()) {
                this.shouldFollowOwner = !this.shouldFollowOwner;
                EnumParticleTypes enumParticleTypes = particle = this.shouldFollowOwner ? EnumParticleTypes.HEART : EnumParticleTypes.SPELL_MOB;
                if (this.shouldFollowOwner) {
                    this.func_175449_a(null, -1);
                } else {
                    this.func_175449_a(this.homePositionBackup, this.homeDistBackup);
                }
            }
            if (particle != null) {
                ((WorldServer)this.field_70170_p).func_180505_a(particle, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, particleCount, 0.3, 0.0, 0.3, 1.0, new int[]{0});
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (itemUsed) {
                this.consumeItemFromStack(player, itemstack);
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    protected void consumeItemFromStack(EntityPlayer player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    public void func_70015_d(int seconds) {
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public void setGameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.gameProfile == null) {
            GameProfile profile = null;
            boolean fallback = false;
            try {
                if (Zombie_Players.zombiePlayerNames != null && Zombie_Players.zombiePlayerNames.length > 0) {
                    String name = Zombie_Players.zombiePlayerNames[this.field_70170_p.field_73012_v.nextInt(Zombie_Players.zombiePlayerNames.length)];
                    if (name.equals("") || name.equals(" ")) {
                        fallback = true;
                    } else {
                        profile = new GameProfile(null, name);
                    }
                } else {
                    fallback = true;
                }
            }
            catch (Exception ex) {
                fallback = true;
            }
            if (fallback) {
                profile = new GameProfile(null, "Corosus");
            }
            this.setGameProfile(profile);
        }
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        this.clearInventory();
        this.func_82227_f(false);
        this.setCanEquip(ConfigZombiePlayers.pickupLootWhenHostile);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(field_110186_bp).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        return data;
    }

    public void clearInventory() {
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            this.func_184201_a(entityequipmentslot, ItemStack.field_190927_a);
        }
    }

    public void setCanEquip(boolean pickupLoot) {
        this.func_98053_h(pickupLoot);
        Arrays.fill(this.field_184655_bs, 1.0f);
        Arrays.fill(this.field_82174_bp, 1.0f);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        String playerName = compound.func_74779_i("playerName");
        String playerUUID = compound.func_74779_i("playerUUID");
        this.gameProfile = new GameProfile(!playerUUID.equals("") ? UUIDTypeAdapter.fromString((String)playerUUID) : null, playerName);
        for (int i = 0; i < MAX_CHESTS; ++i) {
            if (!compound.func_74764_b("chest_" + i + "_X")) continue;
            this.listPosChests.add(new BlockPos(compound.func_74762_e("chest_" + i + "_X"), compound.func_74762_e("chest_" + i + "_Y"), compound.func_74762_e("chest_" + i + "_Z")));
        }
        if (compound.func_74764_b("home_X")) {
            this.func_175449_a(new BlockPos(compound.func_74762_e("home_X"), compound.func_74762_e("home_Y"), compound.func_74762_e("home_Z")), (int)compound.func_74760_g("home_Dist"));
        }
        if (compound.func_74764_b("home_Backup_X")) {
            this.homePositionBackup = new BlockPos(compound.func_74762_e("home_Backup_X"), compound.func_74762_e("home_Backup_X"), compound.func_74762_e("home_Backup_X"));
            this.homeDistBackup = (int)compound.func_74760_g("home_Backup_Dist");
        }
        this.risingTime = compound.func_74762_e("risingTime");
        this.spawnedFromPlayerDeath = compound.func_74767_n("spawnedFromPlayerDeath");
        this.quiet = compound.func_74767_n("quiet");
        this.canEatFromChests = compound.func_74767_n("canEatFromChests");
        this.shouldFollowOwner = compound.func_74767_n("shouldFollowOwner");
        this.calmTime = compound.func_74762_e("calmTime");
        this.ownerName = compound.func_74779_i("ownerName");
        this.lastTimeStartedPlaying = compound.func_74763_f("lastTimeStartedPlaying");
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        if (compound != null) {
            compound.func_74778_a("playerName", this.gameProfile.getName());
            compound.func_74778_a("playerUUID", this.gameProfile.getId() != null ? this.gameProfile.getId().toString() : "");
        }
        for (int i = 0; i < this.listPosChests.size(); ++i) {
            compound.func_74768_a("chest_" + i + "_X", this.listPosChests.get(i).func_177958_n());
            compound.func_74768_a("chest_" + i + "_Y", this.listPosChests.get(i).func_177956_o());
            compound.func_74768_a("chest_" + i + "_Z", this.listPosChests.get(i).func_177952_p());
        }
        if (this.homePositionBackup != null) {
            compound.func_74768_a("home_Backup_X", this.homePositionBackup.func_177958_n());
            compound.func_74768_a("home_Backup_Y", this.homePositionBackup.func_177956_o());
            compound.func_74768_a("home_Backup_Z", this.homePositionBackup.func_177952_p());
            compound.func_74776_a("home_Backup_Dist", (float)this.homeDistBackup);
        }
        if (this.func_180486_cf() != null) {
            compound.func_74768_a("home_X", this.func_180486_cf().func_177958_n());
            compound.func_74768_a("home_Y", this.func_180486_cf().func_177956_o());
            compound.func_74768_a("home_Z", this.func_180486_cf().func_177952_p());
        }
        compound.func_74776_a("home_Dist", this.func_110174_bM());
        compound.func_74768_a("risingTime", this.risingTime);
        compound.func_74757_a("spawnedFromPlayerDeath", this.spawnedFromPlayerDeath);
        compound.func_74757_a("quiet", this.quiet);
        compound.func_74757_a("canEatFromChests", this.canEatFromChests);
        compound.func_74757_a("shouldFollowOwner", this.shouldFollowOwner);
        compound.func_74768_a("calmTime", this.calmTime);
        compound.func_74778_a("ownerName", this.ownerName);
        compound.func_74772_a("lastTimeStartedPlaying", this.lastTimeStartedPlaying);
        return super.func_189511_e(compound);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.risingTime);
        if (this.gameProfile != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.gameProfile.getName());
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)(this.gameProfile.getId() != null ? this.gameProfile.getId().toString() : ""));
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        try {
            this.risingTime = additionalData.readInt();
            String playerName = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
            String playerUUID = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
            this.gameProfile = new GameProfile(!playerUUID.equals("") ? UUIDTypeAdapter.fromString((String)playerUUID) : null, playerName);
        }
        catch (Exception ex) {
            CULog.dbg((String)("exception for EntityZombiePlayer.readSpawnData: " + ex.toString()));
        }
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145818_k_()) {
            return new TextComponentString(this.func_95999_t());
        }
        return new TextComponentString("Zombie " + this.gameProfile.getName());
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return !this.func_110167_bD();
    }

    public int getCalmTime() {
        return this.calmTime;
    }

    public void setCalmTime(int calmTime) {
        this.calmTime = calmTime;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean result = super.func_70652_k(entityIn);
        if (!this.field_70170_p.field_72995_K && entityIn instanceof EntityLivingBase) {
            if (((EntityLivingBase)entityIn).func_110143_aJ() <= 0.0f && this.isCalm()) {
                this.func_70691_i((float)ConfigZombiePlayersAdvanced.healPerKill);
                ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.HEART, false, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e() + 0.5, this.field_70161_v, 1, 0.3, 0.0, 0.3, 1.0, new int[]{0});
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            } else if (this.isCalm()) {
                this.func_70691_i((float)ConfigZombiePlayersAdvanced.healPerHit);
            }
        }
        return result;
    }

    public boolean isFoodNeedUrgent() {
        return this.isCalmTimeLow() || this.isHealthLow();
    }

    public boolean isHealthLow() {
        return this.func_110143_aJ() <= this.func_110138_aP() - 5.0f;
    }

    public boolean isCalmTimeLow() {
        return this.getCalmTime() < 6000;
    }

    public boolean isMeatyChest(BlockPos pos) {
        TileEntity tile = this.field_70170_p.func_175625_s(pos);
        if (tile instanceof TileEntityChest && tile instanceof IInventory) {
            IInventory inv = (IInventory)tile;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_190916_E() <= 0 || !this.isRawMeat(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidChest(BlockPos pos, boolean sightCheck) {
        return this.func_180485_d(pos) && this.isMeatyChest(pos) && (!sightCheck || CoroUtilEntity.canCoordBeSeen((EntityLivingBase)this, (int)pos.func_177958_n(), (int)(pos.func_177956_o() + 1), (int)pos.func_177952_p()));
    }

    public void tickScanForChests() {
        if ((this.field_70170_p.func_82737_E() + (long)this.func_145782_y()) % 600L != 0L) {
            return;
        }
        Iterator<BlockPos> it = this.listPosChests.iterator();
        while (it.hasNext()) {
            BlockPos pos = it.next();
            if (this.isValidChest(pos, false)) continue;
            it.remove();
        }
        if (this.listPosChests.size() >= MAX_CHESTS) {
            return;
        }
        List listEnts = this.field_70170_p.func_72872_a(EntityZombiePlayer.class, new AxisAlignedBB(this.func_180425_c()).func_72314_b(20.0, 20.0, 20.0));
        Collections.shuffle(listEnts);
        for (EntityZombiePlayer ent : listEnts) {
            if (!ent.isCalm()) continue;
            if (this.listPosChests.size() >= MAX_CHESTS) {
                return;
            }
            for (BlockPos pos : ent.listPosChests) {
                if (!this.hasChestAlready(pos) && this.isValidChest(pos, true)) {
                    this.addChestPos(pos);
                }
                if (this.listPosChests.size() < MAX_CHESTS) continue;
                return;
            }
        }
        int range = ConfigZombiePlayersAdvanced.chestSearchRange;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range / 2; y <= range / 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos = this.func_180425_c().func_177982_a(x, y, z);
                    if (!this.isValidChest(pos, true)) continue;
                    if (!this.hasChestAlready(pos)) {
                        this.addChestPos(pos);
                    }
                    if (this.listPosChests.size() < MAX_CHESTS) continue;
                    return;
                }
            }
        }
    }

    public void addChestPos(BlockPos pos) {
        CULog.dbg((String)("zombie player adding chest pos: " + pos));
        this.listPosChests.add(pos);
    }

    public boolean hasChestAlready(BlockPos pos) {
        for (BlockPos pos2 : this.listPosChests) {
            if (!pos.equals((Object)pos2)) continue;
            return true;
        }
        return false;
    }

    public boolean isCanEatFromChests() {
        return this.canEatFromChests;
    }

    public void setCanEatFromChests(boolean canEatFromChests) {
        this.canEatFromChests = canEatFromChests;
    }

    @Nullable
    public UUID func_184753_b() {
        return this.getPlayer() != null ? this.getPlayer().func_110124_au() : null;
    }

    @Nullable
    public Entity func_70902_q() {
        return this.getPlayer();
    }

    public void setOwnerName(String name) {
        this.ownerName = name;
    }

    public EntityPlayer getPlayer() {
        EntityPlayer player;
        if (this.playerWeakReference.get() != null && ((EntityPlayer)this.playerWeakReference.get()).field_70128_L) {
            this.playerWeakReference.clear();
        }
        if (this.playerWeakReference.get() != null && !((EntityPlayer)this.playerWeakReference.get()).field_70128_L) {
            return (EntityPlayer)this.playerWeakReference.get();
        }
        if (this.hasOwner() && (player = this.field_70170_p.func_72924_a(this.ownerName)) != null) {
            this.playerWeakReference = new WeakReference<EntityPlayer>(player);
            return (EntityPlayer)this.playerWeakReference.get();
        }
        return null;
    }

    public boolean hasOwner() {
        return this.ownerName != null && !this.ownerName.equals("");
    }

    public void openChest(BlockPos pos) {
        CULog.dbg((String)"open chest");
        this.hasOpenedChest = true;
        this.chestUseTime = 15;
        this.posChestUsing = pos;
        TileEntity tEnt = this.field_70170_p.func_175625_s(pos);
        if (tEnt instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tEnt;
            ++chest.field_145987_o;
            this.field_70170_p.func_175641_c(pos, chest.func_145838_q(), 1, chest.field_145987_o);
            this.field_70170_p.func_175685_c(pos, chest.func_145838_q(), false);
        }
    }

    public void closeChest(BlockPos pos) {
        CULog.dbg((String)"close chest");
        this.hasOpenedChest = false;
        TileEntity tEnt = this.field_70170_p.func_175625_s(pos);
        if (tEnt instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)tEnt;
            --chest.field_145987_o;
            if (chest.field_145987_o < 0) {
                chest.field_145987_o = 0;
            }
            this.field_70170_p.func_175641_c(pos, chest.func_145838_q(), 1, chest.field_145987_o);
            this.field_70170_p.func_175685_c(pos, chest.func_145838_q(), false);
        }
    }

    public void setHomePosAndDistanceBackup(BlockPos pos, int distance) {
        this.homePositionBackup = pos;
        this.homeDistBackup = distance;
    }

    public void setHomePosAndDistance(BlockPos pos, int distance, boolean setBackup) {
        super.func_175449_a(pos, distance);
        if (setBackup) {
            this.setHomePosAndDistanceBackup(pos, distance);
        }
    }

    public void markStartPlaying() {
        this.lastTimeStartedPlaying = this.field_70170_p.func_82737_E();
    }

    public boolean canPlay() {
        return this.lastTimeStartedPlaying + (long)ConfigZombiePlayersAdvanced.tickDelayBetweenPlaying < this.field_70170_p.func_82737_E();
    }

    public boolean canTrample(World world, Block block, BlockPos pos, float fallDistance) {
        return false;
    }
}

