/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.epicsiegemod.ai;

import com.google.common.base.Function;
import funwayguy.epicsiegemod.ai.ESM_EntityAITarget;
import funwayguy.epicsiegemod.ai.utils.PredicateTargetBasic;
import funwayguy.epicsiegemod.capabilities.combat.CapabilityAttackerHandler;
import funwayguy.epicsiegemod.capabilities.combat.IAttackerHandler;
import funwayguy.epicsiegemod.core.ESM_Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;

public class ESM_EntityAINearestAttackableTarget
extends ESM_EntityAITarget {
    private EntityLiving taskOwner;
    private final List<Predicate<EntityLivingBase>> targetChecks = new ArrayList<Predicate<EntityLivingBase>>();
    private final int targetChance;
    private final EntityAINearestAttackableTarget.Sorter theNearestAttackableTargetSorter;
    private Predicate<? super EntityLivingBase> targetEntitySelector;
    private EntityLivingBase targetEntity;
    private final FunctionEntity visFunc;

    public ESM_EntityAINearestAttackableTarget(EntityLiving host, boolean checkSight) {
        this(host, checkSight, false);
    }

    public ESM_EntityAINearestAttackableTarget(EntityLiving host, boolean checkSight, boolean onlyNearby) {
        this(host, 10, checkSight, onlyNearby, null);
    }

    public ESM_EntityAINearestAttackableTarget(EntityLiving host, int chance, boolean checkSight, boolean onlyNearby, Predicate<? super EntityLivingBase> targetSelector) {
        super(host, checkSight, onlyNearby);
        this.taskOwner = host;
        this.targetChance = chance;
        this.theNearestAttackableTargetSorter = new EntityAINearestAttackableTarget.Sorter((Entity)host);
        this.func_75248_a(1);
        this.visFunc = new FunctionEntity((EntityLivingBase)host);
        this.targetEntitySelector = p_apply_1_ -> p_apply_1_ != null && (targetSelector == null || targetSelector.test((EntityLivingBase)p_apply_1_)) && EntitySelectors.field_180132_d.apply(p_apply_1_) && this.isSuitableTarget((EntityLivingBase)p_apply_1_, false);
    }

    public boolean func_75250_a() {
        if (this.taskOwner.field_70173_aa % 10 != 0) {
            return false;
        }
        if (this.targetChance > 0 && this.taskOwner.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        List list = this.taskOwner.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_188511_a(this.getTargetDistance()), this.targetEntitySelector::test);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.theNearestAttackableTargetSorter);
        this.targetEntity = (EntityLivingBase)list.get(0);
        return true;
    }

    private AxisAlignedBB func_188511_a(double p_188511_1_) {
        return this.taskOwner.func_174813_aQ().func_72314_b(p_188511_1_, 16.0, p_188511_1_);
    }

    @Override
    public void func_75249_e() {
        this.taskOwner.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }

    @Override
    public boolean isSuitableTarget(EntityLivingBase target, boolean includeInvincibles) {
        IEntityOwnable pet;
        IAttackerHandler ah;
        if (!super.isSuitableTarget(target, includeInvincibles)) {
            return false;
        }
        if (target.hasCapability(CapabilityAttackerHandler.ATTACKER_HANDLER_CAPABILITY, null) && (ah = (IAttackerHandler)target.getCapability(CapabilityAttackerHandler.ATTACKER_HANDLER_CAPABILITY, null)) != null && !ah.canAttack(target, this.taskOwner)) {
            return false;
        }
        Double visObj = this.visFunc.apply(target);
        if (visObj != null && (double)this.taskOwner.func_70032_d((Entity)target) > this.getTargetDistance() * visObj) {
            return false;
        }
        boolean flag = false;
        for (Predicate<EntityLivingBase> p : this.targetChecks) {
            if (!p.test(target)) continue;
            flag = true;
            break;
        }
        if (!flag && ESM_Settings.attackPets && target instanceof IEntityOwnable && (pet = (IEntityOwnable)target).func_70902_q() instanceof EntityPlayer) {
            flag = true;
        }
        return flag;
    }

    public void addTarget(Class<? extends EntityLivingBase> target) {
        this.targetChecks.add((Predicate<EntityLivingBase>)((Object)new PredicateTargetBasic<EntityLivingBase>(target)));
    }

    public static class FunctionEntity
    implements Function<EntityLivingBase, Double> {
        EntityLivingBase host;

        private FunctionEntity(EntityLivingBase host) {
            this.host = host;
        }

        public Double apply(EntityLivingBase input) {
            double visibility = 1.0;
            ItemStack itemstack = input.func_184582_a(EntityEquipmentSlot.HEAD);
            if (itemstack.func_77973_b() == Items.field_151144_bL) {
                boolean flag2;
                int i = itemstack.func_77952_i();
                boolean flag0 = this.host instanceof EntitySkeleton && i == 0;
                boolean flag1 = this.host instanceof EntityZombie && i == 2;
                boolean bl = flag2 = this.host instanceof EntityCreeper && i == 4;
                if (flag0 || flag1 || flag2) {
                    visibility *= 0.5;
                }
            } else if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK) && this.host instanceof EntityEnderman) {
                return 0.0;
            }
            if (input.func_70093_af()) {
                visibility *= 0.8;
            }
            if (input.func_82150_aj()) {
                double av = 0.1;
                int total = 0;
                int num = 0;
                Iterable armor = input.func_184193_aE();
                for (ItemStack a : armor) {
                    ++total;
                    if (a == null) continue;
                    ++num;
                }
                if (total > 0) {
                    av = Math.max(0.1, (double)total / (double)num);
                }
                visibility *= av;
            }
            return visibility;
        }
    }
}

