/*
 * Decompiled with CFR 0.152.
 */
package joshie.copy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="copypaste", version="1.1", acceptableRemoteVersions="*", acceptedMinecraftVersions="*")
@Config(modid="copypaste")
public class CopyPaste {
    static final String MODID = "copypaste";
    static final String VERSION = "1.1";
    @Config.Comment(value={"Keep world data updated with the contents of the copy folder"})
    public static boolean copyExisting = true;
    private Logger logger = LogManager.getLogger((String)"copypaste");
    private File root;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.root = new File(event.getModConfigurationDirectory(), "copy");
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        ISaveHandler isavehandler = server.func_71254_M().func_75804_a(server.func_71270_I(), true);
        File directory = isavehandler.func_75765_b();
        File file = new File(directory, "copied.log");
        if (!file.exists()) {
            try {
                this.logger.log(Level.INFO, "Copying files to the world...");
                FileUtils.writeLines((File)file, this.getMD5FromFiles(this.getFilesInDirectory(this.root)));
                FileUtils.copyDirectory((File)this.root, (File)isavehandler.func_75765_b());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.logger.log(Level.ERROR, "There was an error while trying to copy ");
            }
        } else if (copyExisting) {
            try {
                this.logger.log(Level.INFO, "Validating and updating files in the world...");
                List<String> hashes = this.getMD5FromFiles(this.getFilesInDirectory(this.root));
                List existing = FileUtils.readLines((File)file);
                boolean changed = false;
                for (String hash : existing) {
                    if (hashes.contains(hash)) continue;
                    changed = this.deleteFileWithHash(directory, hash);
                }
                if (changed) {
                    FileUtils.listFilesAndDirs((File)directory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).stream().filter(File::isDirectory).forEach(File::delete);
                }
                for (String hash : hashes) {
                    if (existing.contains(hash)) continue;
                    changed = this.copyFileWithHash(directory, hash);
                }
                if (changed) {
                    FileUtils.writeLines((File)file, this.getMD5FromFiles(this.getFilesInDirectory(this.root)));
                }
            }
            catch (IOException ex) {
                this.logger.log(Level.ERROR, "Failed to update an existing world with updated files");
            }
        }
    }

    private List<String> getMD5FromFiles(Collection<File> files) {
        ArrayList<String> hashes = new ArrayList<String>();
        files.stream().filter(File::isFile).forEach(file -> {
            try (FileInputStream fis = new FileInputStream((File)file);){
                hashes.add(DigestUtils.md5Hex((InputStream)fis));
            }
            catch (IOException ex) {
                this.logger.log(Level.ERROR, "Failed to fetch the hash for the file:" + file.toString());
            }
        });
        return hashes;
    }

    private boolean copyFileWithHash(File worldDirectory, String string) {
        for (File file : this.getFilesInDirectory(this.root)) {
            try {
                if (!this.md5Matches(string, file)) continue;
                FileUtils.copyFileToDirectory((File)file, (File)new File(worldDirectory, file.getParentFile().toString().replace(this.root.toString(), "")));
                return true;
            }
            catch (IOException ex) {
                this.logger.log(Level.ERROR, "Failed to copy the file " + file.toString() + " from root to the world");
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean md5Matches(String string, File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            boolean bl = string.equals(DigestUtils.md5Hex((InputStream)fis));
            return bl;
        }
        catch (IOException ex) {
            this.logger.log(Level.ERROR, "Failed to fetch the hash for the file:" + file.toString());
            return false;
        }
    }

    private Collection<File> getFilesInDirectory(File directory) {
        return FileUtils.listFiles((File)directory, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    private boolean deleteFileWithHash(File directory, String string) {
        for (File file : this.getFilesInDirectory(directory)) {
            try {
                if (!file.isFile() || !this.md5Matches(string, file)) continue;
                FileUtils.forceDelete((File)file.getCanonicalFile());
                return true;
            }
            catch (IOException ex) {
                this.logger.log(Level.ERROR, "Failed to delete the file " + file.toString() + " from the world");
            }
        }
        return false;
    }
}

